/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.il;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.NamespaceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.pmapi.ProcessInfoCustomizer;
import org.apache.ode.il.OMUtils;
import org.apache.xmlbeans.XmlObject;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DynamicService<T> {
    private final Log __log = LogFactory.getLog(this.getClass());
    static final OMFactory OM = OMAbstractFactory.getOMFactory();
    T _service;
    Class<T> _clazz;

    public DynamicService(T service) {
        this._clazz = service.getClass();
        this._service = service;
    }

    public OMElement invoke(String operation, OMElement payload) {
        if (this.__log.isDebugEnabled()) {
            this.__log.debug((Object)("Invoke: operation " + operation + " on " + this._clazz + ":\n" + payload));
        }
        String methodName = operation;
        try {
            Method invokedMethod = this.findMethod(methodName);
            Object[] params = this.extractParams(invokedMethod, payload);
            Object result = invokedMethod.invoke(this._service, params);
            OMElement response = null;
            if (result != null) {
                if (this.__log.isDebugEnabled()) {
                    this.__log.debug((Object)("Invoke: operation " + operation + " on " + this._clazz + ":\n" + payload + "\nOM:" + OM + " namespace:" + payload.getNamespace()));
                }
                response = OM.createOMElement(new QName(payload.getNamespace() == null ? "" : payload.getNamespace().getNamespaceURI(), methodName + "Response"));
                OMElement parts = DynamicService.convertToOM(result);
                parts = DynamicService.stripNamespace(parts);
                response.addChild((OMNode)parts);
            }
            if (this.__log.isDebugEnabled()) {
                this.__log.debug((Object)("Response: operation " + operation + " on " + this._clazz + ":\n" + response));
            }
            return response;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Couldn't invoke method named " + methodName + " in management interface!", e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Invocation of method " + methodName + " in management interface failed: " + e.getTargetException().getMessage(), e.getTargetException());
        }
    }

    private Object[] extractParams(Method method, OMElement omElmt) {
        Class<?>[] paramTypes = method.getParameterTypes();
        Object[] params = new Object[method.getParameterTypes().length];
        Iterator omChildren = omElmt.getChildElements();
        int paramIdx = 0;
        for (Class<?> paramClass : paramTypes) {
            OMElement omchild = (OMElement)omChildren.next();
            this.__log.debug((Object)("Extracting param " + paramClass + " from " + omchild));
            params[paramIdx++] = DynamicService.convertFromOM(paramClass, omchild);
        }
        return params;
    }

    private static Object convertFromOM(Class<?> clazz, OMElement elmt) {
        if (elmt == null || elmt.getText().length() == 0 && !elmt.getChildElements().hasNext()) {
            return null;
        }
        if (clazz.equals(String.class)) {
            return elmt.getText();
        }
        if (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE)) {
            return elmt.getText().equals("true") || elmt.getText().equals("yes") ? Boolean.TRUE : Boolean.FALSE;
        }
        if (clazz.equals(QName.class)) {
            return OMUtils.getTextAsQName(elmt);
        }
        if (clazz.equals(ProcessInfoCustomizer.class)) {
            return new ProcessInfoCustomizer(elmt.getText());
        }
        if (Node.class.isAssignableFrom(clazz)) {
            return OMUtils.toDOM(elmt.getFirstElement());
        }
        if (clazz.equals(Long.TYPE) || clazz.equals(Long.class)) {
            return Long.parseLong(elmt.getText());
        }
        if (clazz.equals(Integer.TYPE) || clazz.equals(Integer.class)) {
            return Integer.parseInt(elmt.getText());
        }
        if (clazz.isArray()) {
            ArrayList<Object> alist = new ArrayList<Object>();
            Iterator children = elmt.getChildElements();
            Class<?> targetClazz = clazz.getComponentType();
            while (children.hasNext()) {
                alist.add(DynamicService.parseType(targetClazz, ((OMElement)children.next()).getText()));
            }
            return alist.toArray((Object[])Array.newInstance(targetClazz, alist.size()));
        }
        if (XmlObject.class.isAssignableFrom(clazz)) {
            try {
                Class<?> beanFactory = Class.forName(clazz.getCanonicalName() + "$Factory");
                elmt.setNamespace((OMNamespace)new NamespaceImpl(""));
                elmt.setLocalName("xml-fragment");
                return beanFactory.getMethod("parse", XMLStreamReader.class).invoke(null, elmt.getXMLStreamReaderWithoutCaching());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("Couldn't find class " + clazz.getCanonicalName() + ".Factory to instantiate xml bean", e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Couldn't access class " + clazz.getCanonicalName() + ".Factory to instantiate xml bean", e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException("Couldn't access xml bean parse method on class " + clazz.getCanonicalName() + ".Factory " + "to instantiate xml bean", e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Couldn't find xml bean parse method on class " + clazz.getCanonicalName() + ".Factory " + "to instantiate xml bean", e);
            }
        }
        throw new RuntimeException("Couldn't use element " + elmt + " to obtain a management method parameter.");
    }

    private static OMElement convertToOM(Object obj) {
        if (obj instanceof XmlObject) {
            try {
                return new StAXOMBuilder(((XmlObject)obj).newInputStream()).getDocumentElement();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException("Couldn't serialize result to an outgoing messages.", e);
            }
        }
        if (obj instanceof List) {
            OMElement listElmt = OM.createOMElement("list", null);
            for (Object stuff : (List)obj) {
                OMElement stuffElmt = OM.createOMElement("element", null);
                stuffElmt.setText(stuff.toString());
                listElmt.addChild((OMNode)stuffElmt);
            }
            return listElmt;
        }
        throw new RuntimeException("Couldn't convert object " + obj + " into a response element.");
    }

    private static OMElement stripNamespace(OMElement element) {
        OMElement parent = OM.createOMElement(new QName("", element.getLocalName()));
        Iterator iter = element.getChildElements();
        while (iter.hasNext()) {
            OMElement child = (OMElement)iter.next();
            child = child.cloneOMElement();
            parent.addChild((OMNode)child);
        }
        return parent;
    }

    private Method findMethod(String methodName) {
        for (Method method : this._clazz.getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        throw new RuntimeException("Couldn't find any method named " + methodName + " in interface " + this._clazz.getName());
    }

    private static Object parseType(Class<?> clazz, String str) {
        if (clazz.equals(Integer.class)) {
            return Integer.valueOf(str);
        }
        if (clazz.equals(Float.class)) {
            return Integer.valueOf(str);
        }
        if (clazz.equals(String.class)) {
            return str;
        }
        return null;
    }
}

