/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.TransactionManager;
import javax.xml.namespace.QName;
import junit.framework.AssertionFailedError;
import org.apache.ode.bpel.common.evt.DebugBpelEventListener;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.iapi.BindingContext;
import org.apache.ode.bpel.iapi.BpelEventListener;
import org.apache.ode.bpel.iapi.CacheProvider;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MessageExchangeContext;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.memdao.BpelDAOConnectionFactoryImpl;
import org.apache.ode.dao.bpel.BpelDAOConnectionFactory;
import org.apache.ode.dao.store.ConfStoreDAOConnectionFactory;
import org.apache.ode.il.MockScheduler;
import org.apache.ode.il.cache.CacheProviderFactory;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.il.dbutil.Database;
import org.apache.ode.store.ProcessConfImpl;
import org.apache.ode.store.ProcessStoreImpl;
import org.apache.ode.test.BindingContextImpl;
import org.apache.ode.test.MessageExchangeContextImpl;
import org.apache.ode.test.MockTransactionManager;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class BPELTestAbstract {
    public static final long WAIT_BEFORE_INVOKE_TIMEOUT = 2000L;
    private static final String SHOW_EVENTS_ON_CONSOLE = "no";
    protected BpelServerImpl _server;
    protected ProcessStore store;
    protected MessageExchangeContextImpl mexContext;
    protected EntityManager em;
    protected EntityManagerFactory emf;
    protected MockScheduler scheduler;
    protected BpelDAOConnectionFactory _bcf;
    protected ConfStoreDAOConnectionFactory _scf;
    protected List<Failure> _failures;
    protected List<Deployment> _deployments;
    protected List<Invocation> _invocations;
    private List<Deployment> _deployed;
    private MockTransactionManager _txm;
    private Database _db;
    private CacheProvider _cp;

    @Before
    public void setUp() throws Exception {
        this._failures = new CopyOnWriteArrayList<Failure>();
        this._server = new BpelServerImpl();
        this.mexContext = new MessageExchangeContextImpl();
        this._deployments = new ArrayList<Deployment>();
        this._invocations = new ArrayList<Invocation>();
        this._deployed = new ArrayList<Deployment>();
        this._txm = new MockTransactionManager();
        Properties props = new Properties();
        props.setProperty("dao.factory.store", System.getProperty("dao.factory.store", OdeConfigProperties.DEFAULT_DAOCF_STORE_CLASS));
        props.setProperty("cache.provider", System.getProperty("cache.provider", "org.apache.ode.il.cache.DefaultCacheProvider"));
        OdeConfigProperties odeProps = new OdeConfigProperties(props, "");
        this._db = new Database(odeProps);
        this._db.setTransactionManager((TransactionManager)this._txm);
        this._db.start();
        if (Boolean.getBoolean("org.apache.ode.test.persistent")) {
            this._server.setDaoConnectionFactory(this._bcf);
            this.scheduler = new MockScheduler(){

                public void beginTransaction() {
                    super.beginTransaction();
                    BPELTestAbstract.this.em.getTransaction().begin();
                }

                public void commitTransaction() {
                    super.commitTransaction();
                    BPELTestAbstract.this.em.getTransaction().commit();
                }

                public void rollbackTransaction() {
                    super.rollbackTransaction();
                    BPELTestAbstract.this.em.getTransaction().rollback();
                }
            };
        } else {
            this.scheduler = new MockScheduler((TransactionManager)this._txm);
            this._bcf = new BpelDAOConnectionFactoryImpl((Scheduler)this.scheduler);
            this._bcf.init(null, (TransactionManager)this._txm, (Object)this._txm);
            this._server.setDaoConnectionFactory(this._bcf);
        }
        this._server.setInMemDaoConnectionFactory((BpelDAOConnectionFactory)new BpelDAOConnectionFactoryImpl((Scheduler)this.scheduler));
        this._server.setScheduler((Scheduler)this.scheduler);
        this._server.setBindingContext((BindingContext)new BindingContextImpl());
        this._server.setMessageExchangeContext((MessageExchangeContext)this.mexContext);
        this.scheduler.setJobProcessor((Scheduler.JobProcessor)this._server);
        EndpointReferenceContext eprContext = new EndpointReferenceContext(){

            public EndpointReference resolveEndpointReference(Element epr) {
                return null;
            }

            public EndpointReference convertEndpoint(QName targetType, Element sourceEndpoint) {
                return null;
            }

            public Map getConfigLookup(EndpointReference epr) {
                return Collections.EMPTY_MAP;
            }
        };
        this._scf = this._db.createDaoStoreCF();
        this._cp = CacheProviderFactory.getCacheProvider((OdeConfigProperties)odeProps);
        this._cp.start(null);
        this.store = new ProcessStoreImpl(eprContext, (TransactionManager)this._txm, this._scf, this._cp);
        this.store.registerListener(new ProcessStoreListener(){

            public void onProcessStoreEvent(ProcessStoreEvent event) {
                BPELTestAbstract.this._server.unregister(event.pid);
                if (event.type != ProcessStoreEvent.Type.UNDEPLOYED) {
                    ProcessConfImpl conf = (ProcessConfImpl)BPELTestAbstract.this.store.getProcessConfiguration(event.pid);
                    conf.setTransient(true);
                    BPELTestAbstract.this._server.register((ProcessConf)conf);
                }
            }
        });
        this._server.setConfigProperties(this.getConfigProperties());
        this._server.registerBpelEventListener((BpelEventListener)new DebugBpelEventListener());
        this._server.init();
        this._server.start();
    }

    @After
    public void tearDown() throws Exception {
        for (Deployment d : this._deployed) {
            try {
                this.store.undeploy(d.deployDir);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.err.println("Error undeploying " + d);
            }
        }
        if (this.em != null) {
            this.em.close();
        }
        if (this.emf != null) {
            this.emf.close();
        }
        this._cp.stop();
        this._server.stop();
        this._failures = null;
        this._deployed = null;
        this._deployments = null;
        this._invocations = null;
    }

    protected void negative(String deployDir) throws Throwable {
        try {
            this.go(new File(deployDir));
        }
        catch (AssertionFailedError ex) {
            return;
        }
        Assert.fail((String)"Expecting test to fail");
    }

    protected void go(String deployDir) throws Exception {
        this.go(this.makeDeployDir(deployDir));
    }

    protected Deployment addDeployment(String deployDir) {
        return this.addDeployment(this.makeDeployDir(deployDir));
    }

    protected Deployment addDeployment(File deployDir) {
        Deployment deployment = new Deployment(deployDir);
        this._deployments.add(deployment);
        return deployment;
    }

    protected void go(File deployDir) throws Exception {
        this.setup(deployDir);
        this.go();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setup(File deployDir) throws Exception {
        this.addDeployment(deployDir);
        int propsFileCnt = 0;
        File testPropsFile = new File(deployDir, "test.properties");
        if (!testPropsFile.exists() && !(testPropsFile = new File(deployDir, "test" + ++propsFileCnt + ".properties")).exists()) {
            System.err.println("can't find " + testPropsFile);
        }
        if (!testPropsFile.exists()) {
            Assert.fail((String)("Test property file not found in " + deployDir));
        }
        while (testPropsFile.exists()) {
            Properties testProps = new Properties();
            FileInputStream is = new FileInputStream(testPropsFile);
            try {
                testProps.load(is);
            }
            finally {
                ((InputStream)is).close();
            }
            QName serviceId = new QName(testProps.getProperty("namespace"), testProps.getProperty("service"));
            String operation = testProps.getProperty("operation");
            Boolean sequential = Boolean.parseBoolean(testProps.getProperty("sequential", "false"));
            Invocation last = null;
            int i = 1;
            while (testProps.getProperty("request" + i) != null) {
                String in = testProps.getProperty("request" + i);
                String responsePattern = testProps.getProperty("response" + i);
                last = this.addInvoke(testPropsFile + "#" + i, serviceId, operation, in, responsePattern, sequential != false ? last : null);
                ++i;
            }
            testPropsFile = new File(deployDir, "test" + ++propsFileCnt + ".properties");
        }
    }

    protected Invocation addInvoke(String id, QName target, String operation, String request, String responsePattern) throws Exception {
        return this.addInvoke(id, target, operation, request, responsePattern, null);
    }

    protected Invocation addInvoke(String id, QName target, String operation, String request, String responsePattern, Invocation synchronizeWith) throws Exception {
        Invocation inv = new Invocation(id, synchronizeWith);
        inv.target = target;
        inv.operation = operation;
        inv.request = DOMUtils.stringToDOM((String)request);
        inv.expectedStatus = null;
        if (responsePattern != null) {
            inv.expectedFinalStatus = MessageExchange.Status.RESPONSE;
            inv.expectedResponsePattern = Pattern.compile(responsePattern, 32);
        }
        this._invocations.add(inv);
        return inv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void go() throws Exception {
        try {
            this.doDeployments();
            this.doInvokes();
        }
        finally {
            this.checkFailure();
        }
    }

    protected void checkFailure() {
        StringBuffer sb = new StringBuffer("Failure report:\n");
        for (Failure failure : this._failures) {
            sb.append(failure);
            sb.append('\n');
        }
        if (this._failures.size() != 0) {
            System.err.println(sb.toString());
            Assert.fail((String)sb.toString());
        }
    }

    protected Deployment deploy(String location) {
        Deployment deployment = new Deployment(this.makeDeployDir(location));
        this.doDeployment(deployment);
        return deployment;
    }

    protected void doDeployments() {
        for (Deployment d : this._deployments) {
            this.doDeployment(d);
        }
    }

    protected void doDeployment(Deployment d) {
        block9: {
            Collection procs;
            try {
                procs = this.store.deploy(d.deployDir);
                this._deployed.add(d);
            }
            catch (Exception ex) {
                if (d.expectedException == null) {
                    ex.printStackTrace();
                    this.failure(d, "DEPLOY: Unexpected exception: " + ex, ex);
                } else if (!d.expectedException.isAssignableFrom(ex.getClass())) {
                    ex.printStackTrace();
                    this.failure(d, "DEPLOY: Wrong exception; expected " + d.expectedException + " but got " + ex.getClass(), ex);
                }
                return;
            }
            try {
                for (QName procName : procs) {
                    ProcessConfImpl conf = (ProcessConfImpl)this.store.getProcessConfiguration(procName);
                    conf.setTransient(true);
                    this._server.register((ProcessConf)conf);
                }
            }
            catch (Exception ex) {
                if (d.expectedException == null) {
                    this.failure(d, "REGISTER: Unexpected exception: " + ex, ex);
                }
                if (d.expectedException.isAssignableFrom(ex.getClass())) break block9;
                this.failure(d, "REGISTER: Wrong exception; expected " + d.expectedException + " but got " + ex.getClass(), ex);
            }
        }
    }

    protected void doUndeployments() {
        for (Deployment d : this._deployments) {
            try {
                this.undeploy(d);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.failure(d, "Undeployment failed.", ex);
            }
        }
        this._deployments.clear();
    }

    protected void undeploy(Deployment d) {
        if (this._deployed.contains(d)) {
            this._deployed.remove(d);
            this.store.undeploy(d.deployDir);
        }
    }

    protected void doInvokes() throws Exception {
        ArrayList<InvokerThread> testThreads = new ArrayList<InvokerThread>();
        for (Invocation invocation : this._invocations) {
            InvokerThread t = new InvokerThread(invocation);
            testThreads.add(t);
        }
        for (Thread thread : testThreads) {
            thread.start();
            if (testThreads.size() <= 0) continue;
            Thread.sleep(this.getWaitBeforeInvokeTimeout());
        }
        for (Thread thread : testThreads) {
            thread.join();
        }
    }

    protected long getWaitBeforeInvokeTimeout() {
        return 2000L;
    }

    private void failure(Object where) {
        this.failure(where, "Failure", null);
    }

    private void failure(Object where, String message, Exception ex) {
        Failure f = new Failure(where, message, ex);
        this._failures.add(f);
        Assert.fail((String)f.toString());
    }

    private void failure(Object where, String message, Object expected, Object actual) {
        Failure f = new Failure(where, message, expected, actual, null);
        this._failures.add(f);
        Assert.fail((String)f.toString());
    }

    protected boolean isFailed() {
        return !this._failures.isEmpty();
    }

    protected File makeDeployDir(String deployDir) {
        String deployxml = deployDir + "/deploy.xml";
        URL deployxmlurl = this.getClass().getResource(deployxml);
        if (deployxmlurl == null) {
            Assert.fail((String)("Resource not found: " + deployxml));
        }
        try {
            return new File(deployxmlurl.toURI().getPath()).getParentFile();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
            return null;
        }
    }

    protected Properties getConfigProperties() {
        Properties p = new Properties();
        p.setProperty("debugeventlistener.dumpToStdOut", SHOW_EVENTS_ON_CONSOLE);
        return p;
    }

    class InvokerThread
    extends Thread {
        Invocation _invocation;

        InvokerThread(Invocation invocation) {
            this._invocation = invocation;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.run2();
            }
            finally {
                Invocation invocation = this._invocation;
                synchronized (invocation) {
                    this._invocation.done = true;
                    this._invocation.notify();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run2() {
            Future running;
            MyRoleMessageExchange mex;
            try {
                Thread.sleep(this._invocation.invokeDelayMs);
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this._invocation.synchronizeWith != null) {
                Invocation ex = this._invocation.synchronizeWith;
                synchronized (ex) {
                    while (!this._invocation.synchronizeWith.done) {
                        try {
                            this._invocation.synchronizeWith.wait(this._invocation.maximumWaitMs);
                        }
                        catch (InterruptedException e) {
                            BPELTestAbstract.this.failure(this._invocation, "timed out waiting in sequence", e);
                            return;
                        }
                    }
                }
            }
            BPELTestAbstract.this.scheduler.beginTransaction();
            try {
                mex = BPELTestAbstract.this._server.getEngine().createMessageExchange(new GUID().toString(), this._invocation.target, this._invocation.operation);
                BPELTestAbstract.this.mexContext.clearCurrentResponse();
                Message request = mex.createMessage(this._invocation.requestType);
                request.setMessage(this._invocation.request);
                this._invocation.invokeTime = System.currentTimeMillis();
                running = mex.invoke(request);
                MessageExchange.Status status = mex.getStatus();
                MyRoleMessageExchange.CorrelationStatus cstatus = mex.getCorrelationStatus();
                if (this._invocation.expectedStatus != null && !status.equals((Object)this._invocation.expectedStatus)) {
                    BPELTestAbstract.this.failure(this._invocation, "Unexpected message exchange status", this._invocation.expectedStatus, status);
                }
                if (this._invocation.expectedCorrelationStatus != null && !cstatus.equals((Object)this._invocation.expectedCorrelationStatus)) {
                    BPELTestAbstract.this.failure(this._invocation, "Unexpected correlation status", this._invocation.expectedCorrelationStatus, cstatus);
                }
            }
            catch (Exception ex) {
                if (this._invocation.expectedInvokeException == null) {
                    BPELTestAbstract.this.failure(this._invocation, "Unexpected invocation exception.", ex);
                } else if (this._invocation.expectedInvokeException.isAssignableFrom(ex.getClass())) {
                    BPELTestAbstract.this.failure(this._invocation, "Unexpected invocation exception.", this._invocation.expectedInvokeException, ex.getClass());
                }
                return;
            }
            finally {
                BPELTestAbstract.this.scheduler.commitTransaction();
            }
            if (BPELTestAbstract.this.isFailed()) {
                return;
            }
            try {
                running.get(this._invocation.maximumWaitMs, TimeUnit.MILLISECONDS);
            }
            catch (Exception ex) {
                BPELTestAbstract.this.failure(this._invocation, "Exception on future object.", ex);
                return;
            }
            long ctime = System.currentTimeMillis();
            long itime = ctime - this._invocation.invokeTime;
            if (this._invocation.minimumWaitMs != null && this._invocation.minimumWaitMs >= itime) {
                BPELTestAbstract.this.failure(this._invocation, "Response received too soon.", this._invocation.minimumWaitMs, itime);
            }
            if (this._invocation.maximumWaitMs <= itime) {
                BPELTestAbstract.this.failure(this._invocation, "Response took too long.", this._invocation.maximumWaitMs, itime);
            }
            if (BPELTestAbstract.this.isFailed()) {
                return;
            }
            if (this._invocation.expectedResponsePattern != null) {
                BPELTestAbstract.this.scheduler.beginTransaction();
                try {
                    String responseStr;
                    Matcher matcher;
                    MessageExchange.Status finalstat = mex.getStatus();
                    if (this._invocation.expectedFinalStatus != null && !this._invocation.expectedFinalStatus.equals((Object)finalstat)) {
                        if (finalstat.equals((Object)MessageExchange.Status.FAULT)) {
                            BPELTestAbstract.this.failure(this._invocation, "Unexpected final message exchange status", this._invocation.expectedFinalStatus, "FAULT: " + mex.getFault() + " | " + mex.getFaultExplanation());
                        } else {
                            BPELTestAbstract.this.failure(this._invocation, "Unexpected final message exchange status", this._invocation.expectedFinalStatus, finalstat);
                        }
                    }
                    if (this._invocation.expectedFinalCorrelationStatus != null && !this._invocation.expectedFinalCorrelationStatus.equals((Object)mex.getCorrelationStatus())) {
                        BPELTestAbstract.this.failure(this._invocation, "Unexpected final correlation status", this._invocation.expectedFinalCorrelationStatus, mex.getCorrelationStatus());
                    }
                    if (mex.getResponse() == null) {
                        BPELTestAbstract.this.failure(this._invocation, "Expected response, but got none.", null);
                    }
                    if (!(matcher = this._invocation.expectedResponsePattern.matcher(responseStr = DOMUtils.domToString((Node)mex.getResponse().getMessage()))).matches()) {
                        BPELTestAbstract.this.failure(this._invocation, "Response does not match expected pattern", this._invocation.expectedResponsePattern, responseStr);
                    }
                }
                finally {
                    BPELTestAbstract.this.scheduler.commitTransaction();
                }
            }
        }
    }

    public static class Invocation {
        public String id;
        public Invocation synchronizeWith;
        public boolean done = false;
        public String operation;
        public QName target;
        public Pattern expectedResponsePattern;
        public Element request;
        public long invokeDelayMs = 0L;
        public Class expectedInvokeException = null;
        public MessageExchange.Status expectedStatus = null;
        public MessageExchange.Status expectedFinalStatus = MessageExchange.Status.COMPLETED_OK;
        public MyRoleMessageExchange.CorrelationStatus expectedCorrelationStatus = null;
        public MyRoleMessageExchange.CorrelationStatus expectedFinalCorrelationStatus = null;
        public long maximumWaitMs = 60000L;
        public Long minimumWaitMs = null;
        long invokeTime;
        Exception invokeException;
        QName requestType;

        public Invocation(String id, Invocation synchronizeWith) {
            this.id = id;
            this.synchronizeWith = synchronizeWith;
        }

        public String toString() {
            return "Invocation#" + this.id;
        }
    }

    public static class Deployment {
        public File deployDir;
        public Class expectedException = null;

        public Deployment(File deployDir) {
            this.deployDir = deployDir;
        }

        public String toString() {
            return "Deployment#" + this.deployDir;
        }
    }

    protected static class Failure {
        Object where;
        String msg;
        Object expected;
        Object actual;
        Exception ex;

        public Failure(Object where, String msg, Exception ex) {
            this(where, msg, null, null, ex);
        }

        public Failure(Object where, String msg, Object expected, Object actual, Exception ex) {
            this.actual = actual;
            this.expected = expected;
            this.where = where;
            this.msg = msg;
            this.ex = ex;
        }

        public String toString() {
            StringBuffer sbuf = new StringBuffer(this.where + ": " + this.msg);
            if (this.ex != null) {
                sbuf.append("; got exception msg: " + this.ex.getMessage());
            }
            if (this.actual != null) {
                sbuf.append("; got " + this.actual + ", expected " + this.expected);
            }
            return sbuf.toString();
        }
    }
}

