/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.ode.jacob.Channel;
import org.apache.ode.jacob.ChannelListener;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.vpu.JacobVPU;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JacobObject
implements Serializable {
    public abstract Set<Method> getImplementedMethods();

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    protected static Object getExtension(Class extensionClass) {
        return JacobVPU.activeJacobThread().getExtension(extensionClass);
    }

    protected static <T extends Channel> T importChannel(String channelId, Class<T> channelClass) {
        return (T)JacobVPU.activeJacobThread().importChannel(channelId, channelClass);
    }

    protected static void instance(JacobRunnable concretion) {
        JacobVPU.activeJacobThread().instance(concretion);
    }

    protected <T extends Channel> T newChannel(Class<T> channelType) throws IllegalArgumentException {
        return this.newChannel(channelType, null);
    }

    protected <T extends Channel> T newChannel(Class<T> channelType, String description) throws IllegalArgumentException {
        return (T)JacobVPU.activeJacobThread().newChannel(channelType, this.getClassName(), description);
    }

    protected static <T extends Channel> T object(ChannelListener<T> methodList) {
        JacobVPU.activeJacobThread().object(false, methodList);
        return methodList.getChannel();
    }

    protected static void object(boolean replication, ChannelListener methodList) {
        JacobVPU.activeJacobThread().object(replication, methodList);
    }

    protected static void object(boolean replication, ChannelListener[] methodLists) {
        JacobVPU.activeJacobThread().object(replication, methodLists);
    }

    protected static void object(boolean replication, Set<ChannelListener> methodLists) {
        JacobVPU.activeJacobThread().object(replication, methodLists.toArray(new ChannelListener[methodLists.size()]));
    }

    protected static <T extends Channel> T replication(ChannelListener<T> methodList) {
        JacobVPU.activeJacobThread().object(true, methodList);
        return methodList.getChannel();
    }

    protected static <T extends Channel> T replication(T channel) {
        return channel;
    }

    public Method getMethod(String methodName) {
        Set<Method> implementedMethods = this.getImplementedMethods();
        for (Method m : implementedMethods) {
            if (!m.getName().equals(methodName)) continue;
            return m;
        }
        throw new IllegalArgumentException("No such method \"" + methodName + "\"!");
    }

    public String toString() {
        return "<JacobObject:" + this.getClassName() + ">";
    }
}

