/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.tools;

import org.apache.ode.tools.CommandContext;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class CommandContextErrorHandler
implements ErrorHandler {
    private CommandContext _cc;
    private boolean _err;

    public CommandContextErrorHandler(CommandContext cc) {
        this._cc = cc;
        this._err = false;
    }

    public boolean hadError() {
        return this._err;
    }

    public void warning(SAXParseException exception) throws SAXException {
        this._cc.warn(this.formatMessage(exception));
    }

    public void error(SAXParseException exception) throws SAXException {
        this._err = true;
        this._cc.errln(this.formatMessage(exception));
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this._err = true;
        this._cc.error(this.formatMessage(exception), exception);
        throw exception;
    }

    private String formatMessage(SAXParseException e) {
        StringBuffer sb = new StringBuffer();
        sb.append('[');
        if (e.getSystemId() == null) {
            sb.append("<<null>>");
        } else {
            sb.append(e.getSystemId());
        }
        sb.append(" ");
        sb.append(e.getLineNumber());
        sb.append(':');
        sb.append(e.getColumnNumber());
        sb.append("] ");
        sb.append(e.getMessage());
        return sb.toString();
    }
}

