/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.tools.bpelc;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import org.apache.ode.bpel.compiler.BpelC;
import org.apache.ode.bpel.compiler.BpelCompiler;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.compiler.api.CompilationMessage;
import org.apache.ode.bpel.compiler.api.CompileListener;
import org.apache.ode.tools.Command;
import org.apache.ode.tools.CommandContext;
import org.apache.ode.tools.ExecutionException;
import org.apache.ode.tools.bpelc.BpelCompileCommandMessages;
import org.apache.ode.utils.SystemUtils;
import org.apache.ode.utils.fs.FileUtils;
import org.apache.ode.utils.msg.MessageBundle;

public class BpelCompileCommand
implements Command {
    private static final BpelCompileCommandMessages __msgs = (BpelCompileCommandMessages)MessageBundle.getMessages(BpelCompileCommandMessages.class);
    private short _minSeverity = (short)2;
    private CompileListener _compileListener;
    private CommandContext _cc;
    private File _outputDir;
    private String _wsdlUri;
    private HashSet<String> _bpelFiles = new HashSet();

    public void setCompileListener(CompileListener cl) {
        this._compileListener = cl;
    }

    public void setMinimumSeverity(short m) {
        this._minSeverity = m;
    }

    public void setOuputDirectory(File f) {
        this._outputDir = f;
    }

    public void setWsdlImportUri(String u) {
        this._wsdlUri = u;
    }

    public void addBpelProcessUrl(String u) {
        this._bpelFiles.add(u);
    }

    public void execute(CommandContext cc) throws ExecutionException {
        if (this._bpelFiles.size() == 0) {
            throw new ExecutionException(__msgs.msgAtLeastOneProcessRequired());
        }
        if (this._outputDir == null) {
            this._outputDir = new File(SystemUtils.userDirectory());
        }
        this._cc = cc;
        CompileListener myListener = new CompileListener(){

            public void onCompilationMessage(CompilationMessage m) {
                if (m.severity >= BpelCompileCommand.this._minSeverity) {
                    BpelCompileCommand.this._cc.outln(m.toErrorString());
                }
                if (BpelCompileCommand.this._compileListener != null) {
                    BpelCompileCommand.this._compileListener.onCompilationMessage(m);
                }
            }
        };
        URI u = null;
        if (this._wsdlUri != null) {
            try {
                u = new URI(FileUtils.encodePath((String)this._wsdlUri));
            }
            catch (URISyntaxException use) {
                throw new ExecutionException(__msgs.msgInvalidWsdlUrl(this._wsdlUri));
            }
        }
        for (String bpelURI : this._bpelFiles) {
            BpelC compiler = BpelC.newBpelCompiler();
            if (u != null) {
                compiler.setProcessWSDL(u);
            }
            compiler.setCompileListener(myListener);
            File bpelFile = new File(bpelURI);
            if (!bpelFile.exists()) {
                this._cc.debug("File does not exist: " + bpelFile);
                throw new ExecutionException(__msgs.msgInvalidBpelUrl(bpelURI));
            }
            try {
                long start = System.currentTimeMillis();
                compiler.compile(bpelFile, BpelCompiler.getVersion((String)this._outputDir.getAbsolutePath()));
                long t = System.currentTimeMillis() - start;
                this._cc.info("Compilation completed in " + t + "ms");
            }
            catch (IOException ioe) {
                throw new ExecutionException(__msgs.msgIoExReadingStreamWithMsg(bpelFile, ioe.getMessage()));
            }
            catch (CompilationException e) {
                throw new ExecutionException(e.toErrorMessage(), e);
            }
        }
    }
}

