/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.logging;

import java.util.Arrays;
import org.teiid.CommandContext;
import org.teiid.adminapi.Session;

public class AuditMessage {
    private String context;
    private String activity;
    private LogonInfo logonInfo;
    private Exception exception;
    private Session session;
    private String[] resources;
    private CommandContext commandContext;

    public AuditMessage(String context, String activity, String[] resources, CommandContext commandContext) {
        this.context = context;
        this.activity = activity;
        this.resources = resources;
        this.commandContext = commandContext;
    }

    public AuditMessage(String context, String activity, LogonInfo info, Exception e) {
        this.context = context;
        this.activity = activity;
        this.logonInfo = info;
        this.exception = e;
    }

    public AuditMessage(String context, String activity, Session session) {
        this.context = context;
        this.activity = activity;
        this.session = session;
    }

    public LogonInfo getLogonInfo() {
        return this.logonInfo;
    }

    public Session getSession() {
        if (this.commandContext != null) {
            return this.commandContext.getSession();
        }
        return this.session;
    }

    public String getContext() {
        return this.context;
    }

    public String getActivity() {
        return this.activity;
    }

    public String getPrincipal() {
        Session s = this.getSession();
        if (s != null) {
            return s.getUserName();
        }
        return null;
    }

    public String[] getResources() {
        return this.resources;
    }

    public CommandContext getCommandContext() {
        return this.commandContext;
    }

    public Exception getException() {
        return this.exception;
    }

    public String toString() {
        StringBuffer msg = new StringBuffer();
        if (this.commandContext != null) {
            msg.append(this.commandContext.getRequestId());
        }
        msg.append(" [");
        if (this.logonInfo != null) {
            msg.append(this.logonInfo);
        } else {
            msg.append(this.getPrincipal());
        }
        msg.append("] <");
        msg.append(this.getContext());
        msg.append('.');
        msg.append(this.getActivity());
        msg.append("> ");
        if (this.resources != null) {
            msg.append(Arrays.toString(this.resources));
        }
        return msg.toString();
    }

    public static class LogonInfo {
        private final String vdbName;
        private final String vdbVersion;
        private final String authType;
        private final String userName;
        private final String applicationName;

        public LogonInfo(String vdbName, String vdbVersion, String authType, String userName, String applicationName) {
            this.vdbName = vdbName;
            this.vdbVersion = vdbVersion;
            this.authType = authType;
            this.userName = userName;
            this.applicationName = applicationName;
        }

        public String getVdbName() {
            return this.vdbName;
        }

        public String getVdbVersion() {
            return this.vdbVersion;
        }

        public String getAuthType() {
            return this.authType;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getApplicationName() {
            return this.applicationName;
        }

        public String toString() {
            StringBuffer msg = new StringBuffer();
            msg.append(this.vdbName);
            msg.append(", ");
            msg.append(this.vdbVersion);
            msg.append(' ');
            msg.append(this.userName);
            msg.append(' ');
            msg.append(this.authType);
            return msg.toString();
        }
    }
}

