/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language.visitor;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.teiid.connector.DataPlugin;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.Argument;
import org.teiid.language.Array;
import org.teiid.language.Call;
import org.teiid.language.ColumnReference;
import org.teiid.language.Command;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.Delete;
import org.teiid.language.DerivedColumn;
import org.teiid.language.DerivedTable;
import org.teiid.language.Exists;
import org.teiid.language.Expression;
import org.teiid.language.ExpressionValueSource;
import org.teiid.language.Function;
import org.teiid.language.GroupBy;
import org.teiid.language.In;
import org.teiid.language.Insert;
import org.teiid.language.IsNull;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.Like;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.OrderBy;
import org.teiid.language.Parameter;
import org.teiid.language.QueryExpression;
import org.teiid.language.ScalarSubquery;
import org.teiid.language.SearchedCase;
import org.teiid.language.SearchedWhenClause;
import org.teiid.language.Select;
import org.teiid.language.SetClause;
import org.teiid.language.SetQuery;
import org.teiid.language.SortSpecification;
import org.teiid.language.SubqueryComparison;
import org.teiid.language.SubqueryIn;
import org.teiid.language.TableReference;
import org.teiid.language.Update;
import org.teiid.language.WindowFunction;
import org.teiid.language.WindowSpecification;
import org.teiid.language.With;
import org.teiid.language.WithItem;
import org.teiid.language.visitor.AbstractLanguageVisitor;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.Table;

public class SQLStringVisitor
extends AbstractLanguageVisitor {
    public static final String TEIID_NATIVE_QUERY = "{http://www.teiid.org/ext/relational/2012}native-query";
    private Set<String> infixFunctions = new HashSet<String>(Arrays.asList("%", "+", "-", "*", "+", "/", "||", "&", "|", "^", "#"));
    private static Pattern pattern = Pattern.compile("\\$+\\d+");
    protected static final String UNDEFINED = "<undefined>";
    protected static final String UNDEFINED_PARAM = "?";
    protected StringBuilder buffer = new StringBuilder();
    private boolean appendedSourceComment;
    protected boolean shortNameOnly = false;

    protected String getName(AbstractMetadataRecord object) {
        return SQLStringVisitor.getRecordName(object);
    }

    public static String getRecordName(AbstractMetadataRecord object) {
        return object.getSourceName();
    }

    public void append(LanguageObject obj) {
        if (obj == null) {
            this.buffer.append(UNDEFINED);
        } else {
            this.visitNode(obj);
        }
    }

    protected void append(List<? extends LanguageObject> items) {
        if (items != null && items.size() != 0) {
            this.append(items.get(0));
            for (int i = 1; i < items.size(); ++i) {
                this.buffer.append(",").append(" ");
                this.append(items.get(i));
            }
        }
    }

    protected void append(LanguageObject[] items) {
        if (items != null && items.length != 0) {
            this.append(items[0]);
            for (int i = 1; i < items.length; ++i) {
                this.buffer.append(",").append(" ");
                this.append(items[i]);
            }
        }
    }

    protected String escapeString(String str, String quote) {
        return StringUtil.replaceAll((String)str, (String)quote, (String)(quote + quote));
    }

    public String toString() {
        return this.buffer.toString();
    }

    @Override
    public void visit(AggregateFunction obj) {
        this.buffer.append(obj.getName()).append("(");
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        if (obj.getParameters().isEmpty() && "COUNT".equalsIgnoreCase(obj.getName())) {
            this.buffer.append("*");
        } else {
            this.append(obj.getParameters());
        }
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.append(obj.getOrderBy());
        }
        this.buffer.append(")");
        if (obj.getCondition() != null) {
            this.buffer.append(" ");
            this.buffer.append("FILTER");
            this.buffer.append("(");
            this.buffer.append("WHERE");
            this.buffer.append(" ");
            this.append(obj.getCondition());
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(Comparison obj) {
        this.append(obj.getLeftExpression());
        this.buffer.append(" ");
        this.buffer.append((Object)obj.getOperator());
        this.buffer.append(" ");
        this.appendRightComparison(obj);
    }

    protected void appendRightComparison(Comparison obj) {
        this.append(obj.getRightExpression());
    }

    @Override
    public void visit(AndOr obj) {
        String opString = obj.getOperator().toString();
        this.appendNestedCondition(obj, obj.getLeftCondition());
        this.buffer.append(" ").append(opString).append(" ");
        this.appendNestedCondition(obj, obj.getRightCondition());
    }

    protected void appendNestedCondition(AndOr parent, Condition condition) {
        AndOr nested;
        if (condition instanceof AndOr && (nested = (AndOr)condition).getOperator() != parent.getOperator()) {
            this.buffer.append("(");
            this.append(condition);
            this.buffer.append(")");
            return;
        }
        this.append(condition);
    }

    @Override
    public void visit(Delete obj) {
        this.buffer.append("DELETE").append(" ");
        this.appendSourceComment(obj);
        this.buffer.append("FROM").append(" ");
        this.append(obj.getTable());
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append(obj.getWhere());
        }
    }

    private void appendSourceComment(Command obj) {
        if (this.appendedSourceComment) {
            return;
        }
        this.appendedSourceComment = true;
        this.buffer.append(this.getSourceComment(obj));
    }

    protected String replaceElementName(String group, String element) {
        return null;
    }

    @Override
    public void visit(ColumnReference obj) {
        this.buffer.append(this.getElementName(obj, !this.shortNameOnly));
    }

    private String getElementName(ColumnReference obj, boolean qualify) {
        String groupName = null;
        NamedTable group = obj.getTable();
        if (group != null && qualify) {
            Table groupID;
            groupName = group.getCorrelationName() != null ? group.getCorrelationName() : ((groupID = group.getMetadataObject()) != null ? this.getName(groupID) : group.getName());
        }
        String elemShortName = null;
        Column elementID = obj.getMetadataObject();
        elemShortName = elementID != null ? this.getName(elementID) : obj.getName();
        String replacementElement = this.replaceElementName(groupName, elemShortName);
        if (replacementElement != null) {
            return replacementElement;
        }
        StringBuffer elementName = new StringBuffer(elemShortName.length());
        if (groupName != null) {
            elementName.append(groupName);
            elementName.append(".");
        }
        elementName.append(elemShortName);
        return elementName.toString();
    }

    public static String getShortName(String elementName) {
        int lastDot = elementName.lastIndexOf(".");
        if (lastDot >= 0) {
            elementName = elementName.substring(lastDot + 1);
        }
        return elementName;
    }

    @Override
    public void visit(Call obj) {
        this.buffer.append("EXEC").append(" ");
        if (obj.getMetadataObject() != null) {
            this.buffer.append(this.getName(obj.getMetadataObject()));
        } else {
            this.buffer.append(obj.getProcedureName());
        }
        this.buffer.append("(");
        List<Argument> params = obj.getArguments();
        if (params != null && params.size() != 0) {
            Argument param = null;
            for (int i = 0; i < params.size(); ++i) {
                param = params.get(i);
                if (param.getDirection() != Argument.Direction.IN && param.getDirection() != Argument.Direction.INOUT) continue;
                if (i != 0) {
                    this.buffer.append(",").append(" ");
                }
                this.append(param);
            }
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(Exists obj) {
        this.buffer.append("EXISTS").append(" ").append("(");
        this.append(obj.getSubquery());
        this.buffer.append(")");
    }

    protected boolean isInfixFunction(String function) {
        return this.infixFunctions.contains(function);
    }

    @Override
    public void visit(Function obj) {
        String name = obj.getName();
        List<Expression> args = obj.getParameters();
        if (name.equalsIgnoreCase("CONVERT") || name.equalsIgnoreCase("CAST")) {
            Object typeValue = ((Literal)args.get(1)).getValue();
            this.buffer.append(name);
            this.buffer.append("(");
            this.append(args.get(0));
            if (name.equalsIgnoreCase("CONVERT")) {
                this.buffer.append(",");
                this.buffer.append(" ");
            } else {
                this.buffer.append(" ");
                this.buffer.append("AS");
                this.buffer.append(" ");
            }
            this.buffer.append(typeValue);
            this.buffer.append(")");
        } else if (this.isInfixFunction(name)) {
            this.buffer.append("(");
            if (args != null) {
                for (int i = 0; i < args.size(); ++i) {
                    this.append(args.get(i));
                    if (i >= args.size() - 1) continue;
                    this.buffer.append(" ");
                    this.buffer.append(name);
                    this.buffer.append(" ");
                }
            }
            this.buffer.append(")");
        } else if (name.equalsIgnoreCase("TIMESTAMPADD") || name.equalsIgnoreCase("TIMESTAMPDIFF")) {
            this.buffer.append(name);
            this.buffer.append("(");
            if (args != null && args.size() > 0) {
                this.buffer.append(((Literal)args.get(0)).getValue());
                for (int i = 1; i < args.size(); ++i) {
                    this.buffer.append(",");
                    this.buffer.append(" ");
                    this.append(args.get(i));
                }
            }
            this.buffer.append(")");
        } else if (name.equalsIgnoreCase("TRIM")) {
            this.buffer.append(name);
            this.buffer.append("(");
            String value = (String)((Literal)args.get(0)).getValue();
            if (!value.equalsIgnoreCase("BOTH")) {
                this.buffer.append(value);
                this.buffer.append(" ");
            }
            this.append(args.get(1));
            this.buffer.append(" ");
            this.buffer.append("FROM");
            this.buffer.append(" ");
            this.buffer.append(args.get(2));
            this.buffer.append(")");
        } else {
            this.buffer.append(obj.getName()).append("(");
            this.append(obj.getParameters());
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(NamedTable obj) {
        this.appendBaseName(obj);
        if (obj.getCorrelationName() != null) {
            this.buffer.append(" ");
            if (this.useAsInGroupAlias()) {
                this.buffer.append("AS").append(" ");
            }
            this.buffer.append(obj.getCorrelationName());
        }
    }

    protected void appendBaseName(NamedTable obj) {
        Table groupID = obj.getMetadataObject();
        if (groupID != null) {
            this.buffer.append(this.getName(groupID));
        } else {
            this.buffer.append(obj.getName());
        }
    }

    protected boolean useAsInGroupAlias() {
        return true;
    }

    @Override
    public void visit(GroupBy obj) {
        this.buffer.append("GROUP").append(" ").append("BY").append(" ");
        if (obj.isRollup()) {
            this.buffer.append("ROLLUP");
            this.buffer.append("(");
        }
        this.append(obj.getElements());
        if (obj.isRollup()) {
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(In obj) {
        this.appendNested(obj.getLeftExpression());
        if (obj.isNegated()) {
            this.buffer.append(" ").append("NOT");
        }
        this.buffer.append(" ").append("IN").append(" ").append("(");
        this.append(obj.getRightExpressions());
        this.buffer.append(")");
    }

    @Override
    public void visit(DerivedTable obj) {
        this.buffer.append("(");
        this.append(obj.getQuery());
        this.buffer.append(")");
        this.buffer.append(" ");
        if (this.useAsInGroupAlias()) {
            this.buffer.append("AS");
            this.buffer.append(" ");
        }
        this.buffer.append(obj.getCorrelationName());
    }

    @Override
    public void visit(Insert obj) {
        this.buffer.append(this.getInsertKeyword()).append(" ");
        this.appendSourceComment(obj);
        this.buffer.append("INTO").append(" ");
        this.append(obj.getTable());
        this.buffer.append(" ").append("(");
        this.shortNameOnly = true;
        this.append(obj.getColumns());
        this.shortNameOnly = false;
        this.buffer.append(")");
        this.buffer.append(" ");
        this.append(obj.getValueSource());
    }

    protected String getInsertKeyword() {
        return "INSERT";
    }

    @Override
    public void visit(ExpressionValueSource obj) {
        this.buffer.append("VALUES").append(" ").append("(");
        this.append(obj.getValues());
        this.buffer.append(")");
    }

    @Override
    public void visit(Parameter obj) {
        this.buffer.append('?');
    }

    @Override
    public void visit(IsNull obj) {
        this.appendNested(obj.getExpression());
        this.buffer.append(" ").append("IS").append(" ");
        if (obj.isNegated()) {
            this.buffer.append("NOT").append(" ");
        }
        this.buffer.append("NULL");
    }

    private void appendNested(Expression ex) {
        boolean useParens = ex instanceof Condition;
        if (useParens) {
            this.buffer.append("(");
        }
        this.append(ex);
        if (useParens) {
            this.buffer.append(")");
        }
    }

    @Override
    public void visit(Join obj) {
        TableReference leftItem = obj.getLeftItem();
        if (this.useParensForJoins() && leftItem instanceof Join) {
            this.buffer.append("(");
            this.append(leftItem);
            this.buffer.append(")");
        } else {
            this.append(leftItem);
        }
        this.buffer.append(" ");
        switch (obj.getJoinType()) {
            case CROSS_JOIN: {
                this.buffer.append("CROSS");
                break;
            }
            case FULL_OUTER_JOIN: {
                this.buffer.append("FULL").append(" ").append("OUTER");
                break;
            }
            case INNER_JOIN: {
                this.buffer.append("INNER");
                break;
            }
            case LEFT_OUTER_JOIN: {
                this.buffer.append("LEFT").append(" ").append("OUTER");
                break;
            }
            case RIGHT_OUTER_JOIN: {
                this.buffer.append("RIGHT").append(" ").append("OUTER");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ").append("JOIN").append(" ");
        TableReference rightItem = obj.getRightItem();
        if (rightItem instanceof Join && (this.useParensForJoins() || obj.getJoinType() == Join.JoinType.CROSS_JOIN)) {
            this.buffer.append("(");
            this.append(rightItem);
            this.buffer.append(")");
        } else {
            this.append(rightItem);
        }
        Condition condition = obj.getCondition();
        if (condition != null) {
            this.buffer.append(" ").append("ON").append(" ");
            this.append(condition);
        }
    }

    @Override
    public void visit(Like obj) {
        this.append(obj.getLeftExpression());
        if (obj.isNegated()) {
            this.buffer.append(" ").append("NOT");
        }
        this.buffer.append(" ");
        switch (obj.getMode()) {
            case LIKE: {
                this.buffer.append("LIKE");
                break;
            }
            case SIMILAR: {
                this.buffer.append("SIMILAR").append(" ").append("TO");
            }
            case REGEX: {
                this.buffer.append(this.getLikeRegexString());
            }
        }
        this.buffer.append(" ");
        this.append(obj.getRightExpression());
        if (obj.getEscapeCharacter() != null) {
            this.buffer.append(" ").append("ESCAPE").append(" ").append("'").append(this.escapeString(String.valueOf(obj.getEscapeCharacter()), "'")).append("'");
        }
    }

    protected String getLikeRegexString() {
        return "LIKE_REGEX";
    }

    @Override
    public void visit(Limit obj) {
        this.buffer.append("LIMIT").append(" ");
        if (obj.getRowOffset() > 0) {
            this.buffer.append(obj.getRowOffset()).append(",").append(" ");
        }
        this.buffer.append(obj.getRowLimit());
    }

    @Override
    public void visit(Literal obj) {
        if (obj.getValue() == null) {
            this.buffer.append("NULL");
        } else {
            Class<?> type = obj.getType();
            this.appendLiteral(obj, type);
        }
    }

    protected void appendLiteral(Literal obj, Class<?> type) {
        String val = obj.getValue().toString();
        if (Number.class.isAssignableFrom(type)) {
            this.buffer.append(val);
        } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
            this.buffer.append(obj.getValue().equals(Boolean.TRUE) ? "TRUE" : "FALSE");
        } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
            this.buffer.append("{ts '").append(val).append("'}");
        } else if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
            this.buffer.append("{t '").append(val).append("'}");
        } else if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
            this.buffer.append("{d '").append(val).append("'}");
        } else if (type.equals(DataTypeManager.DefaultDataClasses.VARBINARY)) {
            this.buffer.append("X'").append(val).append("'");
        } else {
            this.buffer.append("'").append(this.escapeString(val, "'")).append("'");
        }
    }

    @Override
    public void visit(Not obj) {
        this.buffer.append("NOT").append(" ").append("(");
        this.append(obj.getCriteria());
        this.buffer.append(")");
    }

    @Override
    public void visit(OrderBy obj) {
        this.buffer.append("ORDER").append(" ").append("BY").append(" ");
        this.append(obj.getSortSpecifications());
    }

    @Override
    public void visit(SortSpecification obj) {
        this.append(obj.getExpression());
        if (obj.getOrdering() == SortSpecification.Ordering.DESC) {
            this.buffer.append(" ").append("DESC");
        }
        if (obj.getNullOrdering() != null) {
            this.buffer.append(" ").append("NULLS").append(" ").append(obj.getNullOrdering().name());
        }
    }

    @Override
    public void visit(Argument obj) {
        this.visitNode(obj.getExpression());
    }

    @Override
    public void visit(Select obj) {
        if (obj.getWith() != null) {
            this.append(obj.getWith());
        }
        this.buffer.append("SELECT").append(" ");
        this.appendSourceComment(obj);
        if (obj.isDistinct()) {
            this.buffer.append("DISTINCT").append(" ");
        }
        if (this.useSelectLimit() && obj.getLimit() != null) {
            this.append(obj.getLimit());
            this.buffer.append(" ");
        }
        this.append(obj.getDerivedColumns());
        if (obj.getFrom() != null && !obj.getFrom().isEmpty()) {
            this.buffer.append(" ").append("FROM").append(" ");
            this.append(obj.getFrom());
        }
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append(obj.getWhere());
        }
        if (obj.getGroupBy() != null) {
            this.buffer.append(" ");
            this.append(obj.getGroupBy());
        }
        if (obj.getHaving() != null) {
            this.buffer.append(" ").append("HAVING").append(" ");
            this.append(obj.getHaving());
        }
        if (obj.getOrderBy() != null) {
            this.buffer.append(" ");
            this.append(obj.getOrderBy());
        }
        if (!this.useSelectLimit() && obj.getLimit() != null) {
            this.buffer.append(" ");
            this.append(obj.getLimit());
        }
    }

    @Override
    public void visit(SearchedCase obj) {
        this.buffer.append("CASE");
        for (SearchedWhenClause swc : obj.getCases()) {
            this.append(swc);
        }
        if (obj.getElseExpression() != null) {
            this.buffer.append(" ").append("ELSE").append(" ");
            this.append(obj.getElseExpression());
        }
        this.buffer.append(" ").append("END");
    }

    @Override
    public void visit(SearchedWhenClause obj) {
        this.buffer.append(" ").append("WHEN").append(" ");
        this.append(obj.getCondition());
        this.buffer.append(" ").append("THEN").append(" ");
        this.append(obj.getResult());
    }

    protected String getSourceComment(Command command) {
        return "";
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.buffer.append("(");
        this.append(obj.getSubquery());
        this.buffer.append(")");
    }

    @Override
    public void visit(DerivedColumn obj) {
        this.append(obj.getExpression());
        if (obj.getAlias() != null) {
            this.buffer.append(" ").append("AS").append(" ").append(obj.getAlias());
        }
    }

    @Override
    public void visit(SubqueryComparison obj) {
        this.append(obj.getLeftExpression());
        this.buffer.append(" ");
        switch (obj.getOperator()) {
            case EQ: {
                this.buffer.append("=");
                break;
            }
            case GE: {
                this.buffer.append(">=");
                break;
            }
            case GT: {
                this.buffer.append(">");
                break;
            }
            case LE: {
                this.buffer.append("<=");
                break;
            }
            case LT: {
                this.buffer.append("<");
                break;
            }
            case NE: {
                this.buffer.append("<>");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ");
        switch (obj.getQuantifier()) {
            case ALL: {
                this.buffer.append("ALL");
                break;
            }
            case SOME: {
                this.buffer.append("SOME");
                break;
            }
            default: {
                this.buffer.append(UNDEFINED);
            }
        }
        this.buffer.append(" ");
        this.buffer.append("(");
        this.append(obj.getSubquery());
        this.buffer.append(")");
    }

    @Override
    public void visit(SubqueryIn obj) {
        this.append(obj.getLeftExpression());
        if (obj.isNegated()) {
            this.buffer.append(" ").append("NOT");
        }
        this.buffer.append(" ").append("IN").append(" ").append("(");
        this.append(obj.getSubquery());
        this.buffer.append(")");
    }

    @Override
    public void visit(Update obj) {
        this.buffer.append("UPDATE").append(" ");
        this.appendSourceComment(obj);
        this.append(obj.getTable());
        this.buffer.append(" ").append("SET").append(" ");
        this.append(obj.getChanges());
        if (obj.getWhere() != null) {
            this.buffer.append(" ").append("WHERE").append(" ");
            this.append(obj.getWhere());
        }
    }

    @Override
    public void visit(SetClause clause) {
        this.shortNameOnly = true;
        this.append(clause.getSymbol());
        this.shortNameOnly = false;
        this.buffer.append(" ").append("=").append(" ");
        this.append(clause.getValue());
    }

    @Override
    public void visit(SetQuery obj) {
        Limit limit;
        if (obj.getWith() != null) {
            this.append(obj.getWith());
        }
        this.appendSetQuery(obj, obj.getLeftQuery(), false);
        this.buffer.append(" ");
        this.appendSetOperation(obj.getOperation());
        if (obj.isAll()) {
            this.buffer.append(" ");
            this.buffer.append("ALL");
        }
        this.buffer.append(" ");
        this.appendSetQuery(obj, obj.getRightQuery(), true);
        OrderBy orderBy = obj.getOrderBy();
        if (orderBy != null) {
            this.buffer.append(" ");
            this.append(orderBy);
        }
        if ((limit = obj.getLimit()) != null) {
            this.buffer.append(" ");
            this.append(limit);
        }
    }

    protected void appendSetOperation(SetQuery.Operation operation) {
        this.buffer.append((Object)operation);
    }

    protected boolean useParensForSetQueries() {
        return false;
    }

    protected void appendSetQuery(SetQuery parent, QueryExpression obj, boolean right) {
        if (!(obj instanceof SetQuery) && this.useParensForSetQueries() || !this.useSelectLimit() && (obj.getLimit() != null || obj.getOrderBy() != null) || right && (obj instanceof SetQuery && (parent.isAll() && !((SetQuery)obj).isAll() || parent.getOperation() != ((SetQuery)obj).getOperation()) || obj.getLimit() != null || obj.getOrderBy() != null)) {
            this.buffer.append("(");
            this.append(obj);
            this.buffer.append(")");
        } else {
            if (!parent.isAll() && obj instanceof SetQuery) {
                ((SetQuery)obj).setAll(false);
            }
            this.append(obj);
        }
    }

    @Override
    public void visit(With obj) {
        this.appendedSourceComment = true;
        this.appendWithKeyword(obj);
        this.buffer.append(" ");
        this.append(obj.getItems());
        this.buffer.append(" ");
        this.appendedSourceComment = false;
    }

    protected void appendWithKeyword(With obj) {
        this.buffer.append("WITH");
    }

    @Override
    public void visit(WithItem obj) {
        this.append(obj.getTable());
        this.buffer.append(" ");
        if (obj.getColumns() != null) {
            this.buffer.append("(");
            this.shortNameOnly = true;
            this.append(obj.getColumns());
            this.shortNameOnly = false;
            this.buffer.append(")");
            this.buffer.append(" ");
        }
        this.buffer.append("AS");
        this.buffer.append(" ");
        this.buffer.append("(");
        if (obj.getSubquery() == null) {
            this.buffer.append(UNDEFINED_PARAM);
        } else {
            this.append(obj.getSubquery());
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(WindowFunction windowFunction) {
        this.append(windowFunction.getFunction());
        this.buffer.append(" ");
        this.buffer.append("OVER");
        this.buffer.append(" ");
        this.append(windowFunction.getWindowSpecification());
    }

    @Override
    public void visit(WindowSpecification windowSpecification) {
        this.buffer.append("(");
        boolean needsSpace = false;
        if (windowSpecification.getPartition() != null) {
            this.buffer.append("PARTITION");
            this.buffer.append(" ");
            this.buffer.append("BY");
            this.buffer.append(" ");
            this.append(windowSpecification.getPartition());
            needsSpace = true;
        }
        if (windowSpecification.getOrderBy() != null) {
            if (needsSpace) {
                this.buffer.append(" ");
            }
            this.append(windowSpecification.getOrderBy());
        }
        this.buffer.append(")");
    }

    @Override
    public void visit(Array array) {
        this.buffer.append("(");
        this.append(array.getExpressions());
        if (array.getExpressions().size() == 1) {
            this.buffer.append(",");
        }
        this.buffer.append(")");
    }

    public static String getSQLString(LanguageObject obj) {
        SQLStringVisitor visitor = new SQLStringVisitor();
        visitor.append(obj);
        return visitor.toString();
    }

    protected boolean useParensForJoins() {
        return false;
    }

    protected boolean useSelectLimit() {
        return false;
    }

    public static void parseNativeQueryParts(String nativeQuery, List<Argument> list, StringBuilder stringBuilder, Substitutor substitutor) {
        Matcher m = pattern.matcher(nativeQuery);
        int i = 0;
        while (i < nativeQuery.length()) {
            String match;
            int end;
            if (!m.find(i)) {
                stringBuilder.append(nativeQuery.substring(i));
                break;
            }
            if (m.start() != i) {
                stringBuilder.append(nativeQuery.substring(i, m.start()));
            }
            if (((end = (match = m.group()).lastIndexOf(36)) & 1) == 1) {
                stringBuilder.append(match.substring((end + 1) / 2));
            } else {
                int index;
                if (end != 0) {
                    stringBuilder.append(match.substring(0, end / 2));
                }
                if ((index = Integer.parseInt(match.substring(end + 1)) - 1) < 0 || index >= list.size()) {
                    throw new IllegalArgumentException(DataPlugin.Util.getString("SQLConversionVisitor.invalid_parameter", new Object[]{index + 1, list.size()}));
                }
                Argument arg = list.get(index);
                if (arg.getDirection() != Argument.Direction.IN) {
                    throw new IllegalArgumentException(DataPlugin.Util.getString("SQLConversionVisitor.not_in_parameter", new Object[]{index + 1}));
                }
                substitutor.substitute(arg, stringBuilder, index);
            }
            i = m.end();
        }
    }

    public static interface Substitutor {
        public void substitute(Argument var1, StringBuilder var2, int var3);
    }
}

