/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.factory.ManagedObjectFactory;
import org.jboss.managed.plugins.factory.AbstractManagedObjectFactory;
import org.jboss.managed.plugins.factory.ManagedObjectFactoryBuilder;
import org.jboss.managed.spi.factory.InstanceClassFactory;
import org.jboss.metatype.api.types.CollectionMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.teiid.adminapi.impl.PropertyMetadata;
import org.teiid.adminapi.impl.TranslatorMetaData;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.templates.TranslatorMetadataICF;

public class AdminObjectBuilder {
    private ManagedObjectFactory mof = ManagedObjectFactoryBuilder.create();

    public AdminObjectBuilder() {
        this.mof.setInstanceClassFactory(TranslatorMetaData.class, (InstanceClassFactory)new TranslatorMetadataICF(this.mof));
    }

    public static <T> T buildAO(ManagedCommon mc, Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            Map managedProperties = mc.getProperties();
            for (ManagedProperty mp : managedProperties.values()) {
                MetaValue value = mp.getValue();
                if (value == null) continue;
                MetaType type = value.getMetaType();
                if (type.isSimple()) {
                    PropertiesUtils.setBeanProperty(t, (String)mp.getMappedName(), (Object)((SimpleValue)value).getValue());
                    continue;
                }
                if (type.isPrimitive()) {
                    PropertiesUtils.setBeanProperty(t, (String)mp.getMappedName(), (Object)((SimpleValue)value).getValue());
                    continue;
                }
                if (type.isEnum()) {
                    PropertiesUtils.setBeanProperty(t, (String)mp.getMappedName(), (Object)((EnumValue)value).getValue());
                    continue;
                }
                if (type.isProperties()) continue;
                if (type.isComposite()) {
                    if (!(value instanceof MapCompositeValueSupport)) continue;
                    HashMap myValue = (HashMap)MetaValueFactory.getInstance().unwrap(value);
                    if (mp.getMappedName().equals("JAXBProperties")) {
                        ArrayList<PropertyMetadata> props = new ArrayList<PropertyMetadata>();
                        for (String key : myValue.keySet()) {
                            props.add(new PropertyMetadata(key, (String)myValue.get(key)));
                        }
                        PropertiesUtils.setBeanProperty(t, (String)mp.getMappedName(), props);
                        continue;
                    }
                    PropertiesUtils.setBeanProperty(t, (String)mp.getMappedName(), (Object)myValue);
                    continue;
                }
                if (type.isCollection()) {
                    ArrayList list = new ArrayList();
                    MetaType elementType = ((CollectionMetaType)type).getElementType();
                    if (elementType == AbstractManagedObjectFactory.MANAGED_OBJECT_META_TYPE) {
                        List managedObjects = (List)MetaValueFactory.getInstance().unwrap(value);
                        for (ManagedObject mo : managedObjects) {
                            list.add(AdminObjectBuilder.buildAO((ManagedCommon)mo, mo.getAttachment().getClass()));
                        }
                    } else if (elementType == SimpleMetaType.STRING) {
                        list.addAll((List)MetaValueFactory.getInstance().unwrap(value));
                    } else if (elementType.isComposite()) {
                        list.addAll((List)MetaValueFactory.getInstance().unwrap(value));
                    } else {
                        throw new TeiidRuntimeException("unsupported type");
                    }
                    PropertiesUtils.setBeanProperty(t, (String)mp.getMappedName(), list);
                    continue;
                }
                if (type.isGeneric()) {
                    throw new TeiidRuntimeException("unsupported type");
                }
                if (!type.isTable() && !type.isArray()) continue;
                throw new TeiidRuntimeException("unsupported type");
            }
            return clazz.cast(t);
        }
        catch (InstantiationException e) {
            throw new TeiidRuntimeException((Throwable)e, IntegrationPlugin.Util.getString("class_not_found", new Object[]{clazz.getName()}));
        }
        catch (IllegalAccessException e) {
            throw new TeiidRuntimeException((Throwable)e, IntegrationPlugin.Util.getString("class_not_found", new Object[]{clazz.getName()}));
        }
    }

    public <T> T buildAdminObject(ManagedCommon mc, Class<T> clazz) {
        try {
            T t = clazz.newInstance();
            ManagedObject mo = this.mof.initManagedObject(t, "teiid", "translator");
            for (ManagedProperty mp : mc.getProperties().values()) {
                ManagedProperty dsProp = mo.getProperty(mp.getName());
                if (dsProp == null || mp.getValue() == null) continue;
                dsProp.setValue(mp.getValue());
            }
            return clazz.cast(t);
        }
        catch (InstantiationException e) {
            throw new TeiidRuntimeException((Throwable)e, IntegrationPlugin.Util.getString("class_not_found", new Object[]{clazz.getName()}));
        }
        catch (IllegalAccessException e) {
            throw new TeiidRuntimeException((Throwable)e, IntegrationPlugin.Util.getString("class_not_found", new Object[]{clazz.getName()}));
        }
    }
}

