/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.adminapi.jboss;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.profileservice.spi.ProfileService;
import org.teiid.adminapi.AdminComponentException;
import org.teiid.adminapi.jboss.Admin;
import org.teiid.adminapi.jboss.JBossConfiguration;
import org.teiid.deployers.VDBStatusChecker;

public class AdminProvider {
    public static Admin getLocal(ProfileService profileService, VDBStatusChecker vdbStatusChecker) {
        ProfileConnection pc = new ProfileConnection(profileService);
        return new Admin(pc.getManagementView(), pc.getDeploymentManager(), vdbStatusChecker);
    }

    public static Admin getLocal(VDBStatusChecker vdbStatusChecker) throws AdminComponentException {
        ProfileConnection pc = new ProfileConnection();
        return new Admin(pc.getManagementView(), pc.getDeploymentManager(), vdbStatusChecker);
    }

    public static Admin getRemote(String provideURL, String userid, String password, VDBStatusChecker vdbStatusChecker) throws AdminComponentException {
        ProfileConnection pc = new ProfileConnection(provideURL, userid, password);
        return new Admin(pc.getManagementView(), pc.getDeploymentManager(), vdbStatusChecker);
    }

    static class JaasSecurityHandler
    implements InvocationHandler {
        private Object target;
        private LoginContext loginContext;

        public JaasSecurityHandler(Object target, final String username, final String password) {
            this.target = target;
            JBossConfiguration jaasConfig = new JBossConfiguration();
            try {
                this.loginContext = new LoginContext("profileservice", null, new CallbackHandler(){

                    @Override
                    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                        for (Callback callback : callbacks) {
                            if (callback instanceof NameCallback) {
                                NameCallback nameCallback = (NameCallback)callback;
                                nameCallback.setName(username);
                                continue;
                            }
                            if (callback instanceof PasswordCallback) {
                                PasswordCallback passwordCallback = (PasswordCallback)callback;
                                passwordCallback.setPassword(password.toCharArray());
                                continue;
                            }
                            throw new UnsupportedCallbackException(callback, "Unrecognized Callback: " + callback);
                        }
                    }
                }, jaasConfig);
            }
            catch (LoginException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            this.loginContext.login();
            Object returnValue = method.invoke(this.target, args);
            this.loginContext.logout();
            return returnValue;
        }
    }

    private static class ProfileConnection {
        private static final String PROFILE_SERVICE_JNDI_NAME = "ProfileService";
        private static final String SECURE_PROFILE_SERVICE_JNDI_NAME = "SecureProfileService/remote";
        private static final String NAMING_CONTEXT_FACTORY = "org.jnp.interfaces.NamingContextFactory";
        private static final String JNP_TIMEOUT_JNP_INIT_PROP = "jnp.timeout";
        private static final String JNP_SOTIMEOUT_JNP_INIT_PROP = "jnp.sotimeout";
        private static final String JNP_DISABLE_DISCOVERY_JNP_INIT_PROP = "jnp.disableDiscovery";
        private static final int JNP_TIMEOUT = 60000;
        private static final int JNP_SO_TIMEOUT = 60000;
        private static final boolean JNP_DISABLE_DISCOVERY = true;
        private ProfileService profileService;
        private String userName;
        private String password;

        public ProfileConnection() throws AdminComponentException {
            this.profileService = this.connect(null, null, null);
        }

        public ProfileConnection(ProfileService profileService) {
            this.profileService = profileService;
        }

        public ProfileConnection(String providerURL, String user, String password) throws AdminComponentException {
            this.userName = user;
            this.password = password;
            this.profileService = this.connect(providerURL, user, password);
        }

        public ManagementView getManagementView() {
            return this.profileService.getViewManager();
        }

        public DeploymentManager getDeploymentManager() {
            return this.profileService.getDeploymentManager();
        }

        private ProfileService connect(String providerURL, String user, String password) throws AdminComponentException {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                if (providerURL == null) {
                    InitialContext ic = new InitialContext();
                    ProfileService profileService = (ProfileService)ic.lookup(PROFILE_SERVICE_JNDI_NAME);
                    return profileService;
                }
                Properties env = new Properties();
                env.setProperty("java.naming.provider.url", providerURL);
                env.setProperty("java.naming.factory.initial", NAMING_CONTEXT_FACTORY);
                env.setProperty("java.naming.security.principal", user);
                env.setProperty("java.naming.security.credentials", password);
                env.put("java.naming.factory.url.pkgs", "org.jnp.interfaces");
                env.setProperty(JNP_DISABLE_DISCOVERY_JNP_INIT_PROP, "true");
                env.setProperty(JNP_TIMEOUT_JNP_INIT_PROP, String.valueOf(60000));
                env.setProperty(JNP_SOTIMEOUT_JNP_INIT_PROP, String.valueOf(60000));
                env.setProperty(JNP_DISABLE_DISCOVERY_JNP_INIT_PROP, String.valueOf(true));
                env.setProperty("java.naming.factory.url.pkgs", "org.jboss.naming:org.jnp.interfaces");
                InitialContext ic = new InitialContext(env);
                try {
                    ProfileService profileService = (ProfileService)ic.lookup(PROFILE_SERVICE_JNDI_NAME);
                    return profileService;
                }
                catch (NamingException e) {
                    try {
                        ProfileService ps = (ProfileService)ic.lookup(SECURE_PROFILE_SERVICE_JNDI_NAME);
                        ProfileService profileService = (ProfileService)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{ProfileService.class}, (InvocationHandler)new JaasSecurityHandler(ps, this.userName, this.password));
                        Thread.currentThread().setContextClassLoader(originalContextClassLoader);
                        return profileService;
                    }
                    catch (NamingException e2) {
                        throw new AdminComponentException((Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
        }
    }
}

