/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.io.IOException;
import java.security.Key;
import java.security.Principal;
import java.security.acl.Group;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.resource.security.AbstractPasswordCredentialLoginModule;
import org.jboss.security.Base64Utils;
import org.jboss.security.SimplePrincipal;
import org.teiid.jboss.SecurityActions;
import org.teiid.jboss.Util;

public class RoleBasedCredentialMapIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private Properties credentialMap;
    private String mappedRole = "mappedRole";
    private static final Logger log = Logger.getLogger(RoleBasedCredentialMapIdentityLoginModule.class);
    private char[] pbepass = "jaas is the way".toCharArray();
    private String pbealgo = "PBEwithMD5andDES";
    private byte[] salt = new byte[]{1, 7, 2, 9, 3, 11, 4, 13};
    private int iterationCount = 37;
    private boolean encryptionInUse = false;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        super.initialize(subject, handler, sharedState, options);
        String file = (String)options.get("credentialMap");
        if (file == null) {
            throw new IllegalArgumentException("Must supply credentialMap file name!");
        }
        try {
            this.credentialMap = Util.loadProperties(file, log);
        }
        catch (IOException e) {
            log.error((Object)"failed to load credentail map");
        }
        String tmp = (String)options.get("encryptedPasswords");
        if (tmp != null && tmp.equalsIgnoreCase("true")) {
            this.encryptionInUse = true;
            tmp = (String)options.get("pbepass");
            if (tmp != null) {
                try {
                    this.pbepass = org.jboss.security.Util.loadPassword((String)tmp);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            if ((tmp = (String)options.get("pbealgo")) != null) {
                this.pbealgo = tmp;
            }
            if ((tmp = (String)options.get("salt")) != null) {
                this.salt = tmp.substring(0, 8).getBytes();
            }
            if ((tmp = (String)options.get("iterationCount")) != null) {
                this.iterationCount = Integer.parseInt(tmp);
            }
        }
    }

    public boolean login() throws LoginException {
        if (this.credentialMap == null) {
            throw new LoginException("Credential Map properties file failed to load");
        }
        return super.login();
    }

    public boolean commit() throws LoginException {
        String userRole = null;
        String rolePassword = null;
        Set<String> roles = this.getRoles();
        for (String role : roles) {
            String password = this.credentialMap.getProperty(role);
            if (password == null) continue;
            userRole = role;
            rolePassword = password;
        }
        try {
            if (userRole != null && rolePassword != null) {
                this.mappedRole = userRole;
                PasswordCredential cred = new PasswordCredential(userRole, this.decode(rolePassword));
                cred.setManagedConnectionFactory(this.getMcf());
                SecurityActions.addCredentials(this.subject, cred);
            }
            return super.commit();
        }
        catch (Exception e) {
            throw new LoginException("Failed to decode password: " + e.getMessage());
        }
    }

    protected Principal getIdentity() {
        SimplePrincipal principal = new SimplePrincipal(this.mappedRole);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    private Set<String> getRoles() {
        HashSet<String> roles = new HashSet<String>();
        Set<Principal> principals = this.subject.getPrincipals();
        for (Principal p : principals) {
            if (!(p instanceof Group) || !p.getName().equals("Roles")) continue;
            Group g = (Group)p;
            Enumeration rolesPrinciples = g.members();
            while (rolesPrinciples.hasMoreElements()) {
                roles.add(((Principal)rolesPrinciples.nextElement()).getName());
            }
        }
        return roles;
    }

    private char[] decode(String secret) throws Exception {
        if (!this.encryptionInUse) {
            return secret.toCharArray();
        }
        PBEParameterSpec cipherSpec = new PBEParameterSpec(this.salt, this.iterationCount);
        PBEKeySpec keySpec = new PBEKeySpec(this.pbepass);
        SecretKeyFactory factory = SecretKeyFactory.getInstance(this.pbealgo);
        SecretKey cipherKey = factory.generateSecret(keySpec);
        byte[] encoding = Base64Utils.fromb64((String)secret);
        Cipher cipher = Cipher.getInstance(this.pbealgo);
        cipher.init(2, (Key)cipherKey, cipherSpec);
        byte[] decode = cipher.doFinal(encoding);
        return new String(decode).toCharArray();
    }
}

