/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss.deployers;

import java.util.List;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentGroup;
import org.jboss.resource.metadata.mcf.ManagedConnectionFactoryDeploymentMetaData;
import org.teiid.deployers.VDBStatusChecker;

public class ConnectionFactoryDeployer
extends AbstractSimpleRealDeployer<ManagedConnectionFactoryDeploymentGroup> {
    private VDBStatusChecker vdbChecker;

    public ConnectionFactoryDeployer() {
        super(ManagedConnectionFactoryDeploymentGroup.class);
        this.setRelativeOrder(3000);
    }

    public void deploy(DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup group) throws DeploymentException {
        List deployments = group.getDeployments();
        for (ManagedConnectionFactoryDeploymentMetaData data : deployments) {
            this.vdbChecker.dataSourceAdded(data.getJndiName());
        }
    }

    public void undeploy(DeploymentUnit unit, ManagedConnectionFactoryDeploymentGroup group) {
        super.undeploy(unit, (Object)group);
        List deployments = group.getDeployments();
        for (ManagedConnectionFactoryDeploymentMetaData data : deployments) {
            this.vdbChecker.dataSourceRemoved(data.getJndiName());
        }
    }

    public void setVDBStatusChecker(VDBStatusChecker checker) {
        this.vdbChecker = checker;
    }
}

