/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.templates.connector;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.resource.cci.ConnectionFactory;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.BasicDeploymentTemplateInfo;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.teiid.adminapi.jboss.ExtendedPropertyInfo;
import org.teiid.deployers.ManagedPropertyUtil;
import org.teiid.templates.connector.RaXmlPropertyConverter;

public class ConnectorTemplateInfo
extends BasicDeploymentTemplateInfo
implements ExtendedPropertyInfo {
    private static final long serialVersionUID = 9066758787789280783L;
    private String rarName;
    static final String TEMPLATE_NAME = "template-name";

    public ConnectorTemplateInfo(String name, String description, Map<String, ManagedProperty> properties) {
        super(name, description, properties);
    }

    public void start() {
        this.populate();
    }

    public ConnectorTemplateInfo copy() {
        ConnectorTemplateInfo copy = new ConnectorTemplateInfo(this.getName(), this.getDescription(), this.getProperties());
        copy.setRarName(this.getRarName());
        super.copy((BasicDeploymentTemplateInfo)copy);
        copy.populate();
        ManagedProperty mp = (ManagedProperty)copy.getProperties().get("connection-definition");
        mp.setValue((MetaValue)SimpleValueSupport.wrap((Serializable)((Object)ConnectionFactory.class.getName())));
        mp = (ManagedProperty)copy.getProperties().get("rar-name");
        mp.setValue((MetaValue)SimpleValueSupport.wrap((Serializable)((Object)this.getRarName())));
        return copy;
    }

    private void populate() {
        List<ManagedProperty> props = RaXmlPropertyConverter.getAsManagedProperties(this.getRarName());
        for (ManagedProperty p : props) {
            this.addProperty(p);
        }
        this.addProperty(ConnectorTemplateInfo.buildTemplateProperty(this.getName()));
    }

    public String getRarName() {
        return this.rarName;
    }

    public void setRarName(String rarName) {
        this.rarName = rarName;
    }

    static ManagedProperty buildTemplateProperty(String name) {
        return ManagedPropertyUtil.createProperty((String)TEMPLATE_NAME, (MetaType)SimpleMetaType.STRING, (String)"Template Name", (String)"The Name of the Teiid Connector Template", (boolean)true, (boolean)true, (Serializable)((Object)name));
    }

    @Override
    public void updateProperty(String name, String value, ManagedComponent main) {
        List<String> connectorNames = RaXmlPropertyConverter.getPropertyNames(this.getRarName());
        if (connectorNames.contains(name)) {
            ConnectorTemplateInfo.updateManagedConnectionFactory(name, value, main);
        }
    }

    static void updateManagedConnectionFactory(String name, String value, ManagedComponent mc) {
        MapCompositeValueSupport previousValues = (MapCompositeValueSupport)mc.getProperty("config-property").getValue();
        if (previousValues != null) {
            previousValues.put(name, (MetaValue)SimpleValueSupport.wrap((Serializable)((Object)value)));
        }
    }
}

