/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.templates.connector;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.resource.cci.ConnectionFactory;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.resource.metadata.ConfigPropertyMetaData;
import org.jboss.resource.metadata.ConnectionDefinitionMetaData;
import org.jboss.resource.metadata.ConnectorMetaData;
import org.jboss.resource.metadata.DescriptionMetaData;
import org.teiid.adminapi.jboss.ManagedUtil;
import org.teiid.deployers.ExtendedPropertyMetadata;
import org.teiid.deployers.ManagedPropertyUtil;

public class RaXmlPropertyConverter {
    public static List<String> getPropertyNames(String rarName) {
        ArrayList<String> names = new ArrayList<String>();
        Collection<ConfigPropertyMetaData> props = RaXmlPropertyConverter.getRarProperties(rarName);
        if (props != null) {
            for (ConfigPropertyMetaData p : props) {
                names.add(p.getName());
            }
        }
        return names;
    }

    public static List<ManagedProperty> getAsManagedProperties(String rarName) {
        ArrayList<ManagedProperty> managedProperties = new ArrayList<ManagedProperty>();
        Collection<ConfigPropertyMetaData> props = RaXmlPropertyConverter.getRarProperties(rarName);
        if (props != null) {
            for (ConfigPropertyMetaData p : props) {
                managedProperties.add(RaXmlPropertyConverter.createConnectorProperty(p));
            }
        }
        return managedProperties;
    }

    private static Collection<ConfigPropertyMetaData> getRarProperties(String rarName) {
        try {
            MBeanServer server = MBeanServerFactory.findMBeanServer(null).get(0);
            ObjectName on = new ObjectName("jboss.jca:service=RARDeployment,name='" + rarName + "'");
            ConnectorMetaData obj = (ConnectorMetaData)server.getAttribute(on, "MetaData");
            ConnectionDefinitionMetaData metadata = obj.getConnectionDefinition(ConnectionFactory.class.getName());
            if (metadata != null) {
                return metadata.getProperties();
            }
        }
        catch (MalformedObjectNameException e) {
        }
        catch (AttributeNotFoundException e) {
        }
        catch (InstanceNotFoundException e) {
        }
        catch (MBeanException e) {
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
        return null;
    }

    private static ManagedProperty createConnectorProperty(ConfigPropertyMetaData metadata) {
        DescriptionMetaData descMetadata = metadata.getDescription();
        String description = descMetadata.getDescription();
        if (description != null) {
            ExtendedPropertyMetadata extended = new ExtendedPropertyMetadata(metadata.getName(), metadata.getType(), description, metadata.getValue());
            return ManagedPropertyUtil.convert((ExtendedPropertyMetadata)extended);
        }
        DefaultFieldsImpl fields = new DefaultFieldsImpl(metadata.getName());
        SimpleMetaType metaType = SimpleMetaType.resolve((String)metadata.getType());
        fields.setMetaType((MetaType)metaType);
        if (metadata.getValue() != null && metadata.getValue().trim().length() > 0) {
            fields.setField("defaultValue", (Object)ManagedUtil.wrap((MetaType)metaType, metadata.getValue()));
        }
        return new ManagedPropertyImpl((Fields)fields);
    }
}

