/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.templates.connector;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.jboss.managed.api.Fields;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.BasicDeploymentTemplateInfo;
import org.jboss.managed.plugins.DefaultFieldsImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.resource.deployers.management.DsDataSourceTemplateInfo;
import org.teiid.adminapi.jboss.ExtendedPropertyInfo;
import org.teiid.adminapi.jboss.ManagedUtil;
import org.teiid.deployers.ManagedPropertyUtil;
import org.teiid.templates.connector.ConnectorTemplateInfo;

public class XaJdbcConnectorTemplateInfo
extends DsDataSourceTemplateInfo
implements ExtendedPropertyInfo {
    private static final long serialVersionUID = 9066758787789280783L;
    static final String SERVER_NAME = "ServerName";
    static final String PORT_NUMBER = "PortNumber";
    static final String DATABASE_NAME = "DatabaseName";
    static final String ADDITIONAL_DS_PROPS = "additional-ds-properties";
    static final String[] EXTENDED_DS_PROPERTIES = new String[]{"ServerName", "PortNumber", "DatabaseName"};

    public XaJdbcConnectorTemplateInfo(String name, String description, Map<String, ManagedProperty> properties) {
        super(name, description, properties);
    }

    public void start() {
        this.populate();
    }

    public XaJdbcConnectorTemplateInfo copy() {
        XaJdbcConnectorTemplateInfo copy = new XaJdbcConnectorTemplateInfo(this.getName(), this.getDescription(), this.getProperties());
        super.copy((BasicDeploymentTemplateInfo)copy);
        copy.populate();
        return copy;
    }

    private void populate() {
        super.start();
        ManagedProperty mp = (ManagedProperty)this.getProperties().get("connection-definition");
        mp.setValue((MetaValue)ManagedUtil.wrap((MetaType)SimpleMetaType.STRING, "javax.sql.DataSource"));
        mp = (ManagedProperty)this.getProperties().get("dsType");
        mp.setValue((MetaValue)ManagedUtil.wrap((MetaType)SimpleMetaType.STRING, "xa-datasource"));
        ManagedPropertyImpl dsTypeMP = XaJdbcConnectorTemplateInfo.buildConfigProperty();
        this.addProperty((ManagedProperty)dsTypeMP);
        this.addProperty(ConnectorTemplateInfo.buildTemplateProperty(this.getName()));
        ManagedPropertyUtil.markAsTeiidProperty((ManagedProperty)((ManagedProperty)this.getProperties().get("user-name")));
        ManagedPropertyUtil.markAsTeiidProperty((ManagedProperty)((ManagedProperty)this.getProperties().get("password")));
        this.addProperty(ManagedPropertyUtil.createProperty((String)DATABASE_NAME, (MetaType)SimpleMetaType.STRING, (String)"Database Name", (String)"Database Name", (boolean)false, (boolean)false, null));
        this.addProperty(ManagedPropertyUtil.createProperty((String)PORT_NUMBER, (MetaType)SimpleMetaType.INTEGER, (String)"Database Port", (String)"Database Port", (boolean)false, (boolean)false, null));
        this.addProperty(ManagedPropertyUtil.createProperty((String)SERVER_NAME, (MetaType)SimpleMetaType.STRING, (String)"Database Server Name", (String)"Database Server Name", (boolean)false, (boolean)false, null));
        this.addProperty(ManagedPropertyUtil.createProperty((String)ADDITIONAL_DS_PROPS, (MetaType)SimpleMetaType.STRING, (String)"Addtional Data Source Properties", (String)"Addtional Data source properties. (comma separated name value pairs)", (boolean)false, (boolean)false, null));
    }

    static ManagedPropertyImpl buildConfigProperty() {
        DefaultFieldsImpl fields = new DefaultFieldsImpl("config-property");
        fields.setDescription("The config-property type");
        fields.setMetaType((MetaType)new MapCompositeMetaType((MetaType)SimpleMetaType.STRING));
        ManagedPropertyImpl dsTypeMP = new ManagedPropertyImpl((Fields)fields);
        return dsTypeMP;
    }

    @Override
    public void updateProperty(String name, String value, ManagedComponent main) {
        if (name.equals(DATABASE_NAME) || name.equals(PORT_NUMBER) || name.equals(SERVER_NAME) || name.equals(ADDITIONAL_DS_PROPS)) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (name.equals(ADDITIONAL_DS_PROPS)) {
                XaJdbcConnectorTemplateInfo.parseProperties(value, map);
            } else {
                map.put(name, value);
            }
            MapCompositeValueSupport previousValues = (MapCompositeValueSupport)main.getProperty("xa-datasource-properties").getValue();
            if (previousValues != null) {
                for (String key : map.keySet()) {
                    previousValues.put(key, (MetaValue)SimpleValueSupport.wrap((Serializable)((Serializable)map.get(key))));
                }
            }
        }
    }

    static void parseProperties(String str, Map<String, String> props) {
        str = str.trim();
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String property = st.nextToken();
            int index = property.indexOf(61);
            if (index == -1 || property.length() <= index + 1) continue;
            props.put(property.substring(0, index).trim(), property.substring(index + 1).trim());
        }
    }
}

