/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.concurrent.Executor;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.JBossLifeCycleListener;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.jdbc.TeiidSQLException;
import org.teiid.logging.LogManager;
import org.teiid.runtime.MaterializationManager;

class MaterializationManagementService
implements Service<MaterializationManager> {
    private Timer timer;
    private MaterializationManager manager;
    protected final InjectedValue<DQPCore> dqpInjector = new InjectedValue();
    protected final InjectedValue<Executor> executorInjector = new InjectedValue();
    protected final InjectedValue<VDBRepository> vdbRepositoryInjector = new InjectedValue();
    private JBossLifeCycleListener shutdownListener;

    public MaterializationManagementService(JBossLifeCycleListener shutdownListener) {
        this.shutdownListener = shutdownListener;
    }

    public void start(StartContext context) throws StartException {
        this.timer = new Timer("Teiid Timer", true);
        this.manager = new MaterializationManager(this.shutdownListener){

            public Timer getTimer() {
                return MaterializationManagementService.this.timer;
            }

            public Executor getExecutor() {
                return (Executor)MaterializationManagementService.this.executorInjector.getValue();
            }

            public List<Map<String, String>> executeQuery(VDBMetaData vdb, String cmd) throws SQLException {
                try {
                    ModelNode results = new ModelNode();
                    LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50100, new Object[]{"executing=" + cmd}));
                    TeiidOperationHandler.executeQuery(vdb, (DQPCore)MaterializationManagementService.this.dqpInjector.getValue(), cmd, -1L, results, false);
                    ArrayList<Map<String, String>> rows = new ArrayList<Map<String, String>>();
                    int i = 0;
                    while (results.get(i).isDefined()) {
                        HashMap<String, String> row = new HashMap<String, String>();
                        List cols = results.get(i).asList();
                        for (ModelNode col : cols) {
                            if (!col.getType().equals((Object)ModelType.PROPERTY)) continue;
                            Property p = col.asProperty();
                            row.put(p.getName(), p.getValue().asString());
                        }
                        rows.add(row);
                        ++i;
                    }
                    LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50100, new Object[]{results}));
                    return rows;
                }
                catch (Throwable t) {
                    throw new TeiidSQLException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50100, new Object[]{t}));
                }
            }
        };
        ((VDBRepository)this.vdbRepositoryInjector.getValue()).addListener((VDBLifeCycleListener)this.manager);
    }

    public void stop(StopContext context) {
        this.timer.cancel();
        ((VDBRepository)this.vdbRepositoryInjector.getValue()).removeListener((VDBLifeCycleListener)this.manager);
    }

    public MaterializationManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this.manager;
    }
}

