/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import javax.naming.InitialContext;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.teiid.common.buffer.BufferManager;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.ReferenceFactoryService;
import org.teiid.jboss.TeiidConstants;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TransportService;
import org.teiid.logging.LogManager;
import org.teiid.net.socket.AuthenticationType;
import org.teiid.transport.ClientServiceRegistry;
import org.teiid.transport.LocalServerConnection;
import org.teiid.transport.SSLConfiguration;
import org.teiid.transport.SocketConfiguration;

class TransportAdd
extends AbstractAddStepHandler {
    public static TransportAdd INSTANCE = new TransportAdd();
    public static SimpleAttributeDefinition[] ATTRIBUTES = new SimpleAttributeDefinition[]{TeiidConstants.TRANSPORT_PROTOCOL_ATTRIBUTE, TeiidConstants.TRANSPORT_SOCKET_BINDING_ATTRIBUTE, TeiidConstants.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE, TeiidConstants.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE, TeiidConstants.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE, TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE, TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE, TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE, TeiidConstants.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE, TeiidConstants.AUTHENTICATION_TYPE_ATTRIBUTE, TeiidConstants.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT, TeiidConstants.SSL_MODE_ATTRIBUTE, TeiidConstants.SSL_AUTH_MODE_ATTRIBUTE, TeiidConstants.SSL_SSL_PROTOCOL_ATTRIBUTE, TeiidConstants.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE, TeiidConstants.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_NAME_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_PASSWORD_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_TYPE_ATTRIBUTE, TeiidConstants.SSL_TRUSTSTORE_NAME_ATTRIBUTE, TeiidConstants.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_ALIAS_ATTRIBUTE, TeiidConstants.SSL_KETSTORE_KEY_PASSWORD_ATTRIBUTE};

    TransportAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (int i = 0; i < ATTRIBUTES.length; ++i) {
            ATTRIBUTES[i].validateAndSet(operation, model);
        }
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceTarget target = context.getServiceTarget();
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String transportName = pathAddress.getLastElement().getValue();
        TransportService transport = new TransportService(transportName);
        String socketBinding = null;
        if (TeiidConstants.isDefined(TeiidConstants.TRANSPORT_SOCKET_BINDING_ATTRIBUTE, operation, context)) {
            socketBinding = TeiidConstants.asString(TeiidConstants.TRANSPORT_SOCKET_BINDING_ATTRIBUTE, operation, context);
            transport.setSocketConfig(this.buildSocketConfiguration(context, operation));
        } else {
            transport.setEmbedded(true);
            LogManager.logDetail((String)"org.teiid.SECURITY", (Object)IntegrationPlugin.Util.getString("socket_binding_not_defined", new Object[]{transportName}));
        }
        String securityDomain = null;
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE, operation, context)) {
            securityDomain = TeiidConstants.asString(TeiidConstants.AUTHENTICATION_SECURITY_DOMAIN_ATTRIBUTE, operation, context);
            transport.setAuthenticationDomain(securityDomain);
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE, operation, context)) {
            transport.setSessionMaxLimit(TeiidConstants.asLong(TeiidConstants.AUTHENTICATION_MAX_SESSIONS_ALLOWED_ATTRIBUTE, operation, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE, operation, context)) {
            transport.setSessionExpirationTimeLimit(TeiidConstants.asLong(TeiidConstants.AUTHENTICATION_SESSION_EXPIRATION_TIME_LIMIT_ATTRIBUTE, operation, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE, operation, context)) {
            LogManager.logWarning((String)"org.teiid.SECURITY", (Object)IntegrationPlugin.Util.getString("security_not_correct", new Object[]{transportName}));
            transport.setAuthenticationType(AuthenticationType.GSS);
            transport.setAuthenticationDomain(TeiidConstants.asString(TeiidConstants.AUTHENTICATION_KRB5_DOMAIN_ATTRIBUTE, operation, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.AUTHENTICATION_TYPE_ATTRIBUTE, operation, context)) {
            transport.setAuthenticationType(AuthenticationType.valueOf((String)TeiidConstants.asString(TeiidConstants.AUTHENTICATION_TYPE_ATTRIBUTE, operation, context)));
        } else {
            transport.setAuthenticationType(AuthenticationType.USERPASSWORD);
        }
        if (TeiidConstants.isDefined(TeiidConstants.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT, operation, context)) {
            transport.setMaxODBCLobSizeAllowed(TeiidConstants.asInt(TeiidConstants.PG_MAX_LOB_SIZE_ALLOWED_ELEMENT, operation, context));
        }
        ServiceBuilder transportBuilder = target.addService(TeiidServiceNames.transportServiceName(transportName), (Service)transport);
        if (socketBinding != null) {
            transportBuilder.addDependency(ServiceName.JBOSS.append(new String[]{"binding", socketBinding}), SocketBinding.class, transport.getSocketBindingInjector());
        }
        transportBuilder.addDependency(TeiidServiceNames.BUFFER_MGR, BufferManager.class, transport.getBufferManagerInjector());
        transportBuilder.addDependency(TeiidServiceNames.VDB_REPO, VDBRepository.class, transport.getVdbRepositoryInjector());
        transportBuilder.addDependency(TeiidServiceNames.ENGINE, DQPCore.class, transport.getDqpInjector());
        transportBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(transportBuilder.install());
        if (transport.isEmbedded() && !this.isEmbeddedRegistered(transportName)) {
            ReferenceFactoryService referenceFactoryService = new ReferenceFactoryService();
            ServiceName referenceFactoryServiceName = TeiidServiceNames.embeddedTransportServiceName(transportName).append(new String[]{"reference-factory"});
            ServiceBuilder referenceBuilder = target.addService(referenceFactoryServiceName, referenceFactoryService);
            referenceBuilder.addDependency(TeiidServiceNames.transportServiceName(transportName), ClientServiceRegistry.class, referenceFactoryService.getInjector());
            referenceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)LocalServerConnection.jndiNameForRuntime((String)transportName));
            BinderService binderService = new BinderService(bindInfo.getBindName());
            ServiceBuilder binderBuilder = target.addService(bindInfo.getBinderServiceName(), (Service)binderService);
            binderBuilder.addDependency(referenceFactoryServiceName, ManagedReferenceFactory.class, binderService.getManagedObjectInjector());
            binderBuilder.addDependency(bindInfo.getParentContextServiceName(), ServiceBasedNamingStore.class, binderService.getNamingStoreInjector());
            binderBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
            newControllers.add(referenceBuilder.install());
            newControllers.add(binderBuilder.install());
        }
    }

    protected boolean isEmbeddedRegistered(String transportName) {
        try {
            InitialContext ic = new InitialContext();
            ic.lookup(LocalServerConnection.jndiNameForRuntime((String)transportName));
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private SocketConfiguration buildSocketConfiguration(OperationContext context, ModelNode node) throws OperationFailedException {
        SocketConfiguration socket = new SocketConfiguration();
        if (TeiidConstants.isDefined(TeiidConstants.TRANSPORT_PROTOCOL_ATTRIBUTE, node, context)) {
            socket.setProtocol(TeiidConstants.asString(TeiidConstants.TRANSPORT_PROTOCOL_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE, node, context)) {
            socket.setMaxSocketThreads(TeiidConstants.asInt(TeiidConstants.TRANSPORT_MAX_SOCKET_THREADS_ATTRIBUTE, node, context).intValue());
        }
        if (TeiidConstants.isDefined(TeiidConstants.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE, node, context)) {
            socket.setInputBufferSize(TeiidConstants.asInt(TeiidConstants.TRANSPORT_IN_BUFFER_SIZE_ATTRIBUTE, node, context).intValue());
        }
        if (TeiidConstants.isDefined(TeiidConstants.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE, node, context)) {
            socket.setOutputBufferSize(TeiidConstants.asInt(TeiidConstants.TRANSPORT_OUT_BUFFER_SIZE_ATTRIBUTE, node, context).intValue());
        }
        SSLConfiguration ssl = new SSLConfiguration();
        if (TeiidConstants.isDefined(TeiidConstants.SSL_MODE_ATTRIBUTE, node, context)) {
            ssl.setMode(TeiidConstants.asString(TeiidConstants.SSL_MODE_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_SSL_PROTOCOL_ATTRIBUTE, node, context)) {
            ssl.setSslProtocol(TeiidConstants.asString(TeiidConstants.SSL_SSL_PROTOCOL_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE, node, context)) {
            ssl.setKeymanagementAlgorithm(TeiidConstants.asString(TeiidConstants.SSL_KEY_MANAGEMENT_ALG_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_AUTH_MODE_ATTRIBUTE, node, context)) {
            ssl.setAuthenticationMode(TeiidConstants.asString(TeiidConstants.SSL_AUTH_MODE_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_KETSTORE_NAME_ATTRIBUTE, node, context)) {
            ssl.setKeystoreFilename(TeiidConstants.asString(TeiidConstants.SSL_KETSTORE_NAME_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_KETSTORE_ALIAS_ATTRIBUTE, node, context)) {
            ssl.setKeystoreKeyAlias(TeiidConstants.asString(TeiidConstants.SSL_KETSTORE_ALIAS_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_KETSTORE_KEY_PASSWORD_ATTRIBUTE, node, context)) {
            ssl.setKeystoreKeyPassword(TeiidConstants.asString(TeiidConstants.SSL_KETSTORE_KEY_PASSWORD_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE, node, context)) {
            ssl.setEnabledCipherSuites(TeiidConstants.asString(TeiidConstants.SSL_ENABLED_CIPHER_SUITES_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_KETSTORE_PASSWORD_ATTRIBUTE, node, context)) {
            ssl.setKeystorePassword(TeiidConstants.asString(TeiidConstants.SSL_KETSTORE_PASSWORD_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_KETSTORE_TYPE_ATTRIBUTE, node, context)) {
            ssl.setKeystoreType(TeiidConstants.asString(TeiidConstants.SSL_KETSTORE_TYPE_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_TRUSTSTORE_NAME_ATTRIBUTE, node, context)) {
            ssl.setTruststoreFilename(TeiidConstants.asString(TeiidConstants.SSL_TRUSTSTORE_NAME_ATTRIBUTE, node, context));
        }
        if (TeiidConstants.isDefined(TeiidConstants.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE, node, context)) {
            ssl.setTruststorePassword(TeiidConstants.asString(TeiidConstants.SSL_TRUSTSTORE_PASSWORD_ATTRIBUTE, node, context));
        }
        socket.setSSLConfiguration(ssl);
        return socket;
    }
}

