/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.RequestMetadata;
import org.teiid.adminapi.jboss.VDBMetadataMapper;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;
import org.teiid.jboss.TransportService;

class ListRequestsPerVDB
extends TeiidOperationHandler {
    protected ListRequestsPerVDB() {
        super("list-requests-per-vdb");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.VDB_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_NAME.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.VDB_VERSION.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_VERSION.getName() + ".missing")));
        }
        boolean includeSourceQueries = true;
        if (operation.hasDefined(OperationsConstants.INCLUDE_SOURCE.getName())) {
            includeSourceQueries = operation.get(OperationsConstants.INCLUDE_SOURCE.getName()).asBoolean();
        }
        ModelNode result = context.getResult();
        String vdbName = operation.get(OperationsConstants.VDB_NAME.getName()).asString();
        int vdbVersion = operation.get(OperationsConstants.VDB_VERSION.getName()).asInt();
        ListRequestsPerVDB.checkVDB(context, vdbName, vdbVersion);
        for (TransportService t : this.getTransportServices(context)) {
            List<RequestMetadata> requests = t.getRequestsUsingVDB(vdbName, vdbVersion);
            for (RequestMetadata request : requests) {
                if (request.sourceRequest()) {
                    if (!includeSourceQueries) continue;
                    VDBMetadataMapper.RequestMetadataMapper.INSTANCE.wrap(request, result.add());
                    continue;
                }
                VDBMetadataMapper.RequestMetadataMapper.INSTANCE.wrap(request, result.add());
            }
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_VERSION);
        builder.addParameter((AttributeDefinition)OperationsConstants.INCLUDE_SOURCE);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyParameters(VDBMetadataMapper.RequestMetadataMapper.INSTANCE.getAttributeDefinitions());
    }
}

