/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.teiid.core.util.NamedThreadFactory;
import org.teiid.deployers.VDBLifeCycleListener;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.JBossLifeCycleListener;
import org.teiid.runtime.MaterializationManager;

class MaterializationManagementService
implements Service<MaterializationManager> {
    private ScheduledExecutorService scheduler;
    private MaterializationManager manager;
    protected final InjectedValue<DQPCore> dqpInjector = new InjectedValue();
    protected final InjectedValue<Executor> executorInjector = new InjectedValue();
    protected final InjectedValue<VDBRepository> vdbRepositoryInjector = new InjectedValue();
    private JBossLifeCycleListener shutdownListener;

    public MaterializationManagementService(JBossLifeCycleListener shutdownListener) {
        this.shutdownListener = shutdownListener;
    }

    public void start(StartContext context) throws StartException {
        this.scheduler = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("Teiid Timer"));
        this.manager = new MaterializationManager(this.shutdownListener){

            public ScheduledExecutorService getScheduledExecutorService() {
                return MaterializationManagementService.this.scheduler;
            }

            public Executor getExecutor() {
                return (Executor)MaterializationManagementService.this.executorInjector.getValue();
            }

            public DQPCore getDQP() {
                return (DQPCore)MaterializationManagementService.this.dqpInjector.getValue();
            }
        };
        ((VDBRepository)this.vdbRepositoryInjector.getValue()).addListener((VDBLifeCycleListener)this.manager);
    }

    public void stop(StopContext context) {
        this.scheduler.shutdownNow();
        ((VDBRepository)this.vdbRepositoryInjector.getValue()).removeListener((VDBLifeCycleListener)this.manager);
    }

    public MaterializationManager getValue() throws IllegalStateException, IllegalArgumentException {
        return this.manager;
    }
}

