/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.ArrayList;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.teiid.adminapi.AdminProcessingException;
import org.teiid.deployers.RuntimeVDB;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.VDBOperations;

class RestartVDB
extends VDBOperations {
    public RestartVDB() {
        super("restart-vdb", true);
    }

    @Override
    protected void executeOperation(OperationContext context, RuntimeVDB vdb, ModelNode operation) throws OperationFailedException {
        ArrayList<String> models = new ArrayList<String>();
        if (operation.hasDefined(OperationsConstants.MODEL_NAMES.getName())) {
            String modelNames = operation.get(OperationsConstants.MODEL_NAMES.getName()).asString();
            for (String model : modelNames.split(",")) {
                models.add(model.trim());
            }
        }
        try {
            vdb.restart(models);
        }
        catch (AdminProcessingException e) {
            throw new OperationFailedException(new ModelNode().set(e.getMessage()));
        }
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        super.describeParameters(builder);
        builder.addParameter((AttributeDefinition)OperationsConstants.MODEL_NAMES);
    }
}

