/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.jboss.TransportService;
import org.teiid.transport.LocalServerConnection;

class TransportRemove
extends AbstractRemoveStepHandler {
    public static TransportRemove INSTANCE = new TransportRemove();

    TransportRemove() {
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceName serviceName;
        ModelNode address = operation.require("address");
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
        String transportName = pathAddress.getLastElement().getValue();
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        ServiceController controller = serviceRegistry.getService(serviceName = TeiidServiceNames.transportServiceName(transportName));
        if (controller != null) {
            TransportService transport = (TransportService)TransportService.class.cast(controller.getValue());
            if (transport.isEmbedded()) {
                ContextNames.BindInfo bindInfo = ContextNames.bindInfoFor((String)LocalServerConnection.jndiNameForRuntime((String)transportName));
                context.removeService(bindInfo.getBinderServiceName());
                context.removeService(TeiidServiceNames.embeddedTransportServiceName(transportName).append(new String[]{"reference-factory"}));
            }
            context.removeService(serviceName);
        }
    }
}

