/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.OperationsConstants;
import org.teiid.jboss.TeiidOperationHandler;

class ExecuteQuery
extends TeiidOperationHandler {
    protected ExecuteQuery() {
        super("execute-query");
    }

    @Override
    protected void executeOperation(OperationContext context, DQPCore engine, ModelNode operation) throws OperationFailedException {
        if (!operation.hasDefined(OperationsConstants.VDB_NAME.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_NAME.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.VDB_VERSION.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.VDB_VERSION.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.SQL_QUERY.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.SQL_QUERY.getName() + ".missing")));
        }
        if (!operation.hasDefined(OperationsConstants.TIMEOUT_IN_MILLI.getName())) {
            throw new OperationFailedException(new ModelNode().set(IntegrationPlugin.Util.getString(OperationsConstants.TIMEOUT_IN_MILLI.getName() + ".missing")));
        }
        ModelNode result = context.getResult();
        String vdbName = operation.get(OperationsConstants.VDB_NAME.getName()).asString();
        int vdbVersion = operation.get(OperationsConstants.VDB_VERSION.getName()).asInt();
        String sql = operation.get(OperationsConstants.SQL_QUERY.getName()).asString();
        int timeout = operation.get(OperationsConstants.TIMEOUT_IN_MILLI.getName()).asInt();
        VDBMetaData vdb = ExecuteQuery.checkVDB(context, vdbName, vdbVersion);
        result.set(ExecuteQuery.executeQuery(vdb, engine, sql, timeout, new ModelNode(), true));
    }

    @Override
    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_NAME);
        builder.addParameter((AttributeDefinition)OperationsConstants.VDB_VERSION);
        builder.addParameter((AttributeDefinition)OperationsConstants.SQL_QUERY);
        builder.addParameter((AttributeDefinition)OperationsConstants.TIMEOUT_IN_MILLI);
        builder.setReplyType(ModelType.LIST);
        builder.setReplyValueType(ModelType.STRING);
    }
}

