/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

import nu.xom.Comment;
import nu.xom.DocType;
import nu.xom.Element;
import nu.xom.IllegalAddException;
import nu.xom.ProcessingInstruction;
import nu.xom.Text;

final class StreamingVerifier {
    private ElementStack elements;
    private boolean hasXMLDeclaration;
    private boolean hasRootElement;
    private boolean hasDocType;

    StreamingVerifier() {
        this.reset();
    }

    public void reset() {
        this.elements = new ElementStack();
        this.hasRootElement = false;
        this.hasDocType = false;
        this.hasXMLDeclaration = false;
    }

    public void writeStartTag(Element elem) {
        if (elem == null) {
            StreamingVerifier.throwNullPointerException();
        }
        if (this.inPrologOrEpilog()) {
            this.checkWriteStartRootTag();
        }
        this.elements.push(elem);
    }

    private void checkWriteStartRootTag() {
        this.checkHasXMLDeclaration();
        if (this.hasRootElement) {
            StreamingVerifier.throwWellformednessException("Document must not have more than one root element");
        }
        this.hasRootElement = true;
    }

    public Element writeEndTag() {
        if (this.inPrologOrEpilog()) {
            StreamingVerifier.throwWellformednessException("Imbalanced element tags; attempted to write an end tag for a nonexistent start tag");
        }
        return this.elements.pop();
    }

    public void write(Text text) {
        if (text == null) {
            StreamingVerifier.throwNullPointerException();
        }
        if (this.inPrologOrEpilog()) {
            StreamingVerifier.throwWellformednessException("Text is not allowed as child of a document");
        }
    }

    public void write(Comment comment) {
        if (comment == null) {
            StreamingVerifier.throwNullPointerException();
        }
        this.checkHasXMLDeclaration();
    }

    public void write(ProcessingInstruction instruction) {
        if (instruction == null) {
            StreamingVerifier.throwNullPointerException();
        }
        this.checkHasXMLDeclaration();
    }

    public void write(DocType docType) {
        if (docType == null) {
            StreamingVerifier.throwNullPointerException();
        }
        this.checkHasXMLDeclaration();
        if (!this.inPrologOrEpilog()) {
            StreamingVerifier.throwWellformednessException("Document type declaration is not allowed as child of an element");
        }
        if (this.hasDocType) {
            StreamingVerifier.throwWellformednessException("Document must not have more than one document type declaration");
        }
        if (this.hasRootElement) {
            StreamingVerifier.throwWellformednessException("Document type declaration is not allowed after the root element");
        }
        this.hasDocType = true;
    }

    public void writeEndDocument() {
        this.checkHasXMLDeclaration();
        if (!this.hasRootElement) {
            StreamingVerifier.throwWellformednessException("Missing root element; a document must have a root element");
        }
    }

    public void writeXMLDeclaration() {
        if (this.hasXMLDeclaration) {
            StreamingVerifier.throwWellformednessException("Document must not have more than one XML declaration");
        }
        this.hasXMLDeclaration = true;
    }

    public int depth() {
        return this.elements.size();
    }

    private boolean inPrologOrEpilog() {
        return this.depth() == 0;
    }

    private void checkHasXMLDeclaration() {
        if (!this.hasXMLDeclaration) {
            StreamingVerifier.throwWellformednessException("Missing XML declaration. Probable causes: 1) forgot to call writeXMLDeclaration() or 2) called writeEndDocument() before without a subsequent writeXMLDeclaration()");
        }
    }

    private static void throwWellformednessException(String message) {
        throw new IllegalAddException(message);
    }

    private static void throwNullPointerException() {
        throw new NullPointerException("Node argument must not be null");
    }

    private static final class ElementStack {
        private Element[] elems = new Element[10];
        private int size = 0;

        private ElementStack() {
        }

        public Element pop() {
            Element elem = this.elems[this.size - 1];
            this.elems[--this.size] = null;
            return elem;
        }

        public void push(Element elem) {
            if (this.size == this.elems.length) {
                this.ensureCapacity(this.size + 1);
            }
            this.elems[this.size++] = elem;
        }

        public int size() {
            return this.size;
        }

        private void ensureCapacity(int minCapacity) {
            if (minCapacity > this.elems.length) {
                int newCapacity = Math.max(minCapacity, 2 * this.elems.length + 1);
                this.elems = this.subArray(0, this.size, newCapacity);
            }
        }

        private Element[] subArray(int from, int length, int capacity) {
            Element[] subArray = new Element[capacity];
            System.arraycopy(this.elems, from, subArray, 0, length);
            return subArray;
        }
    }
}

