/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

import nu.xom.Attribute;
import nux.xom.binary.ArrayByteList;
import nux.xom.binary.BinaryParsingException;

final class Util {
    private Util() {
    }

    public static int noNamespace(int type) {
        return type | 0x80;
    }

    public static boolean hasNoNamespace(int type) {
        return (type >>> 6 & 3) == 2;
    }

    public static void packOneIndex(ArrayByteList dst, int index, int type) {
        int pos = dst.size() - 1;
        type = index < 16 ? Util.inlineIndex(type, index) : (type |= Util.packIndex(dst, index) << 4);
        dst.set(pos, (byte)type);
    }

    public static void packTwoIndexes(ArrayByteList dst, int ix0, int ix1, int type) {
        int pos = dst.size() - 1;
        type |= Util.packIndex(dst, ix0) << 4;
        dst.set(pos, (byte)(type |= Util.packIndex(dst, ix1) << 6));
    }

    public static int packIndex(ArrayByteList dst, int index) {
        if (index < 256) {
            dst.add((byte)index);
            return 0;
        }
        if (index < 65536) {
            dst.addShort((short)index);
            return 1;
        }
        dst.addInt(index);
        return 3;
    }

    public static int inlineIndex(int type, int index) {
        type &= 7;
        return type |= 8 | index << 4;
    }

    public static boolean isInlinedIndex(int type) {
        return (type >>> 3 & 1) != 0;
    }

    public static int getInlinedIndex(int type) {
        return type >>> 4 & 0xF;
    }

    public static byte getAttributeTypeCode(Attribute attr) {
        return (byte)attr.getType().hashCode();
    }

    public static Attribute.Type getAttributeType(int typeCode) throws BinaryParsingException {
        switch (typeCode) {
            case 0: {
                return Attribute.Type.UNDECLARED;
            }
            case 1: {
                return Attribute.Type.CDATA;
            }
            case 2: {
                return Attribute.Type.ID;
            }
            case 3: {
                return Attribute.Type.IDREF;
            }
            case 4: {
                return Attribute.Type.IDREFS;
            }
            case 5: {
                return Attribute.Type.NMTOKEN;
            }
            case 6: {
                return Attribute.Type.NMTOKENS;
            }
            case 7: {
                return Attribute.Type.NOTATION;
            }
            case 8: {
                return Attribute.Type.ENTITY;
            }
            case 9: {
                return Attribute.Type.ENTITIES;
            }
            case 10: {
                return Attribute.Type.ENUMERATION;
            }
        }
        throw new BinaryParsingException("Illegal attribute type code: " + typeCode);
    }

    public static int getUnsignedByte(byte v) {
        return v & 0xFF;
    }

    public static int getUnsignedShort(short v) {
        return v & 0xFFFF;
    }
}

