/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.io;

import java.io.InputStream;
import java.lang.ref.SoftReference;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import nu.xom.Builder;
import nu.xom.Node;
import nu.xom.NodeFactory;
import nu.xom.ParsingException;
import nu.xom.XMLException;
import nux.xom.io.StaxBuilder;
import nux.xom.io.StaxReader;

public class StaxUtil {
    private static final boolean DEBUG = StaxUtil.getSystemProperty("nux.xom.io.StaxUtil.debug", false);
    private static final boolean CACHE_DTDS = StaxUtil.getSystemProperty("nux.xom.io.StaxUtil.cacheDTDs", true);
    private static final DefaultXMLInputFactory defaultInputFactory = new DefaultXMLInputFactory();

    private StaxUtil() {
    }

    public static XMLStreamReader createXMLStreamReader(Node root) {
        return new StaxReader(root);
    }

    public static Builder createBuilder(XMLInputFactory inputFactory, NodeFactory factory) {
        if (inputFactory == null) {
            inputFactory = StaxUtil.getDefaultInputFactory();
        }
        return new StaxBuilder(inputFactory, factory);
    }

    private static XMLInputFactory getDefaultInputFactory() {
        XMLInputFactory inputFactory = StaxUtil.defaultInputFactory.getInputFactory();
        if (DEBUG) {
            System.err.println("got XMLInputFactory=" + inputFactory.getClass().getName());
        }
        return inputFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLStreamReader createXMLStreamReader(InputStream input, String baseURI) throws ParsingException {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        if (baseURI != null && baseURI.length() == 0) {
            baseURI = null;
        }
        XMLInputFactory inputFactory = StaxUtil.getDefaultInputFactory();
        try {
            XMLInputFactory xMLInputFactory = inputFactory;
            synchronized (xMLInputFactory) {
                return inputFactory.createXMLStreamReader(baseURI, input);
            }
        }
        catch (XMLStreamException e) {
            StaxUtil.wrapException(e);
            return null;
        }
    }

    static void wrapException(XMLStreamException ex) throws ParsingException {
        if (DEBUG) {
            ex.printStackTrace();
        }
        String systemID = null;
        int lineNumber = -1;
        int columnNumber = -1;
        Location location = ex.getLocation();
        if (location != null) {
            lineNumber = location.getLineNumber();
            columnNumber = location.getColumnNumber();
            systemID = location.getSystemId();
            if ("".equals(systemID)) {
                systemID = null;
            }
        }
        throw new ParsingException(ex.getMessage(), systemID, lineNumber, columnNumber, (Throwable)ex);
    }

    public static String toString(int eventType) {
        switch (eventType) {
            case 1: {
                return "START_ELEMENT";
            }
            case 2: {
                return "END_ELEMENT";
            }
            case 3: {
                return "PROCESSING_INSTRUCTION";
            }
            case 4: {
                return "CHARACTERS";
            }
            case 5: {
                return "COMMENT";
            }
            case 6: {
                return "SPACE";
            }
            case 7: {
                return "START_DOCUMENT";
            }
            case 8: {
                return "END_DOCUMENT";
            }
            case 9: {
                return "ENTITY_REFERENCE";
            }
            case 10: {
                return "ATTRIBUTE";
            }
            case 11: {
                return "DTD";
            }
            case 12: {
                return "CDATA";
            }
            case 13: {
                return "NAMESPACE";
            }
            case 14: {
                return "NOTATION_DECLARATION";
            }
            case 15: {
                return "ENTITY_DECLARATION";
            }
        }
        return "Unrecognized event type: " + eventType;
    }

    static boolean getSystemProperty(String key, boolean defaults) {
        try {
            return "true".equalsIgnoreCase(System.getProperty(key, String.valueOf(defaults)));
        }
        catch (Throwable e) {
            return defaults;
        }
    }

    private static final class DefaultXMLInputFactory {
        private SoftReference factoryRef = new SoftReference<Object>(null);
        private static final String[] StAX_FACTORIES = new String[]{"com.ctc.wstx.stax.WstxInputFactory", "com.sun.xml.stream.ZephyrParserFactory", "oracle.xml.stream.OracleXMLInputFactory", "com.bea.xml.stream.MXParserFactory"};

        private DefaultXMLInputFactory() {
        }

        private synchronized XMLInputFactory getInputFactory() {
            XMLInputFactory inputFactory = (XMLInputFactory)this.factoryRef.get();
            if (inputFactory == null) {
                inputFactory = this.createInputFactory();
                this.factoryRef = new SoftReference<XMLInputFactory>(inputFactory);
            }
            return inputFactory;
        }

        private XMLInputFactory createInputFactory() {
            XMLInputFactory factory;
            int i = 0;
            while (i < StAX_FACTORIES.length) {
                try {
                    XMLInputFactory factory2 = (XMLInputFactory)ClassLoaderUtil.newInstance(StAX_FACTORIES[i]);
                    DefaultXMLInputFactory.setupProperties(factory2);
                    if (DEBUG) {
                        System.err.println("using XMLInputFactory=" + factory2.getClass().getName());
                    }
                    return factory2;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (NoClassDefFoundError noClassDefFoundError) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++i;
            }
            try {
                factory = XMLInputFactory.newInstance();
                DefaultXMLInputFactory.setupProperties(factory);
            }
            catch (IllegalArgumentException ex) {
                throw new XMLException("Could not find or create a suitable StAX parser - check your classpath", (Throwable)ex);
            }
            catch (Exception ex) {
                throw new XMLException("Could not find or create a suitable StAX parser - check your classpath", (Throwable)ex);
            }
            catch (NoClassDefFoundError ex) {
                throw new XMLException("Could not find or create a suitable StAX parser - check your classpath", (Throwable)ex);
            }
            if (DEBUG) {
                System.err.println("using default XMLInputFactory=" + factory.getClass().getName());
            }
            return factory;
        }

        private static void setupProperties(XMLInputFactory factory) {
            factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
            factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
            factory.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
            try {
                factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String factoryName = factory.getClass().getName();
            if (factoryName.equals("com.ctc.wstx.stax.WstxInputFactory")) {
                try {
                    String P_LAZY_PARSING = "com.ctc.wstx.lazyParsing";
                    factory.setProperty(P_LAZY_PARSING, Boolean.FALSE);
                }
                catch (IllegalArgumentException P_LAZY_PARSING) {
                    // empty catch block
                }
                try {
                    String P_CACHE_DTDS = "com.ctc.wstx.cacheDTDs";
                    factory.setProperty(P_CACHE_DTDS, CACHE_DTDS);
                }
                catch (IllegalArgumentException P_CACHE_DTDS) {}
            } else if (factoryName.equals("com.sun.xml.stream.ZephyrParserFactory")) {
                try {
                    String P_REPORT_CDATA = "report-cdata-event";
                    factory.setProperty(P_REPORT_CDATA, Boolean.TRUE);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private static final class ClassLoaderUtil {
        private static final boolean SIMPLE_MODE = false;
        private static final boolean DEBUG = false;

        private ClassLoaderUtil() {
        }

        public static Object newInstance(String className) throws ClassNotFoundException, InstantiationException, IllegalAccessException {
            ClassLoader classLoader = new ClassLoaderFinder().getContextClassLoader();
            Class<?> clazz = classLoader == null ? Class.forName(className) : classLoader.loadClass(className);
            return clazz.newInstance();
        }

        private static final class ClassLoaderFinder {
            private ClassLoaderFinder() {
            }

            public ClassLoader getContextClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }
        }
    }
}

