/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.io;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.xml.stream.XMLStreamWriter;
import nux.xom.binary.BinaryXMLCodec;
import nux.xom.io.StreamingSerializer;
import nux.xom.io.StreamingStaxSerializer;
import nux.xom.io.StreamingXMLSerializer;

public class StreamingSerializerFactory {
    public StreamingSerializer createBinaryXMLSerializer(OutputStream out, int zlibCompressionLevel) {
        BinaryXMLCodec codec = new BinaryXMLCodec();
        return codec.createStreamingSerializer(out, zlibCompressionLevel);
    }

    public StreamingSerializer createXMLSerializer(OutputStream out, String encoding) {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        try {
            return new StreamingXMLSerializer(out, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public StreamingSerializer createStaxSerializer(XMLStreamWriter writer) {
        return new StreamingStaxSerializer(writer);
    }
}

