/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import nu.xom.Builder;
import nu.xom.XMLException;
import nux.xom.pool.ClassLoaderUtil;
import nux.xom.pool.FileUtil;
import nux.xom.pool.XOMUtil;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class BuilderFactory {
    private final Map featuresAndProperties;
    private static final boolean ENABLE_PARSER_GRAMMAR_POOLS = true;
    private static final boolean DEBUG = XOMUtil.getSystemProperty("nux.xom.pool.BuilderFactory.debug", false);
    private static final String[] PARSERS = new String[]{"org.apache.xerces.parsers.SAXParser", "com.sun.org.apache.xerces.internal.parsers.SAXParser", "gnu.xml.aelfred2.XmlReader", "org.apache.crimson.parser.XMLReaderImpl", "com.bluecast.xml.Piccolo", "oracle.xml.parser.v2.SAXParser", "com.jclark.xml.sax.SAX2Driver", "net.sf.saxon.aelfred.SAXDriver", "com.icl.saxon.aelfred.SAXDriver", "org.dom4j.io.aelfred2.SAXDriver", "org.dom4j.io.aelfred.SAXDriver"};
    private static final Map PARSER_GRAMMAR_POOLS = new HashMap(2);

    static {
        PARSER_GRAMMAR_POOLS.put("org.apache.xerces.parsers.SAXParser", "org.apache.xerces.util.XMLGrammarPoolImpl");
        PARSER_GRAMMAR_POOLS.put("com.sun.org.apache.xerces.internal.parsers.SAXParser", "com.sun.org.apache.xerces.internal.util.XMLGrammarPoolImpl");
    }

    public BuilderFactory() {
        this(null);
    }

    public BuilderFactory(Map featuresAndProperties) {
        this.featuresAndProperties = featuresAndProperties;
    }

    public Builder createBuilder(boolean validate) {
        return this.newBuilder(this.createParser(false), validate);
    }

    public Builder createDTDBuilder(EntityResolver resolver) {
        XMLReader parser = this.createParser(false);
        parser.setEntityResolver(resolver);
        return this.newBuilder(parser, true);
    }

    public EntityResolver createResolver(InputStream in) throws IOException {
        final byte[] data = FileUtil.toByteArray(in);
        return new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) {
                return new InputSource(new ByteArrayInputStream(data));
            }
        };
    }

    public Builder createW3CBuilder(Map schemaLocations) {
        XMLReader parser = this.createParser(true);
        try {
            this.setupW3CParser(parser, schemaLocations);
        }
        catch (SAXException e) {
            throw new XMLException("Can't find or create W3C schema validating parser (i.e. Xerces) - check your classpath", (Throwable)e);
        }
        try {
            parser.setFeature("http://apache.org/xml/features/validation/schema/augment-psvi", false);
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return this.newBuilder(parser, true);
    }

    public Builder createMSVBuilder(InputStream schema, URI systemID) {
        XMLReader parser;
        if (schema == null && systemID == null) {
            throw new IllegalArgumentException("At least one of the parameters 'schema' and 'systemId' must not be null");
        }
        InputSource source = new InputSource();
        if (schema != null) {
            source.setByteStream(schema);
        }
        if (systemID != null) {
            source.setSystemId(systemID.toASCIIString());
        }
        try {
            SAXParserFactory factory = (SAXParserFactory)ClassLoaderUtil.newInstance("com.sun.msv.verifier.jaxp.SAXParserFactoryImpl");
            factory.setNamespaceAware(true);
            SAXParser saxParser = factory.newSAXParser();
            saxParser.setProperty("http://www.sun.com/xml/msv/schema", source);
            XMLReader filter = parser = saxParser.getXMLReader();
            while (filter instanceof XMLFilter && ((XMLFilter)filter).getParent() instanceof XMLFilter) {
                if (DEBUG) {
                    System.err.println("currFilter=" + filter);
                }
                filter = ((XMLFilter)filter).getParent();
            }
            if (filter instanceof XMLFilter) {
                if (DEBUG) {
                    System.err.println("rootFilter=" + filter);
                }
                if (DEBUG) {
                    System.err.println("rootFilter.getParent()=" + ((XMLFilter)filter).getParent());
                }
                ((XMLFilter)filter).setParent(this.createParser(false));
            } else {
                this.setupFeaturesAndProps(parser);
            }
            if (DEBUG) {
                System.err.println("using MSV XMLReader=" + parser.getClass().getName());
            }
        }
        catch (SAXNotRecognizedException ex) {
            throw new XMLException(ex.toString(), (Throwable)ex);
        }
        catch (Exception ex) {
            throw new XMLException("Could not find or create a suitable MSV parser - check your classpath", (Throwable)ex);
        }
        catch (NoClassDefFoundError ex) {
            throw new XMLException("Could not find or create a suitable MSV parser - check your classpath", (Throwable)ex);
        }
        return this.newBuilder(parser, false);
    }

    protected Builder newBuilder(XMLReader parser, boolean validate) {
        return new Builder(parser, validate, null);
    }

    private XMLReader createParser(boolean w3cSchemaParser) {
        int i22 = 0;
        while (i22 < PARSERS.length) {
            try {
                String clazz;
                XMLReader parser = XMLReaderFactory.createXMLReader(PARSERS[i22]);
                if (w3cSchemaParser && (clazz = (String)PARSER_GRAMMAR_POOLS.get(PARSERS[i22])) != null) {
                    parser.setProperty("http://apache.org/xml/properties/internal/grammar-pool", ClassLoaderUtil.newInstance(clazz));
                }
                this.setupFeaturesAndProps(parser);
                if (DEBUG) {
                    System.err.println("using XMLReader=" + parser.getClass().getName());
                }
                return parser;
            }
            catch (SAXException sAXException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i22;
        }
        try {
            XMLReader parser = XMLReaderFactory.createXMLReader();
            this.setupFeaturesAndProps(parser);
            if (DEBUG) {
                System.err.println("using default SAX XMLReader=" + parser.getClass().getName());
            }
            return parser;
        }
        catch (Exception i22) {
            try {
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(true);
                XMLReader parser = factory.newSAXParser().getXMLReader();
                this.setupFeaturesAndProps(parser);
                if (DEBUG) {
                    System.err.println("using default JAXP XMLReader=" + parser.getClass().getName());
                }
                return parser;
            }
            catch (Exception ex) {
                throw new XMLException("Could not find or create a suitable SAX2 parser - check your classpath", (Throwable)ex);
            }
            catch (NoClassDefFoundError ex) {
                throw new XMLException("Could not find or create a suitable SAX2 parser - check your classpath", (Throwable)ex);
            }
        }
    }

    private void setupW3CParser(XMLReader parser, Map schemaLocations) throws SAXNotRecognizedException, SAXNotSupportedException {
        parser.setFeature("http://apache.org/xml/features/validation/schema", true);
        if (schemaLocations == null || schemaLocations.size() == 0) {
            return;
        }
        StringBuffer withNamespaces = new StringBuffer();
        String withoutNamespaces = null;
        Iterator iter = schemaLocations.entrySet().iterator();
        while (iter.hasNext()) {
            String namespace;
            String schema;
            URI uri;
            Map.Entry entry = iter.next();
            Object key = entry.getKey();
            if (key == null) {
                throw new IllegalArgumentException("schema must not be null: " + schemaLocations);
            }
            if (key instanceof File) {
                key = ((File)key).toURI();
            }
            if (key instanceof URI && (uri = (URI)key).getScheme() != null && uri.getScheme().equals("file") && uri.getRawPath() != null) {
                key = "file:" + uri.getRawPath();
            }
            if ((schema = key.toString().trim()).length() == 0) {
                throw new IllegalArgumentException("schema must not have length zero: " + schemaLocations);
            }
            if (DEBUG) {
                System.err.println("schema=" + schema);
            }
            String string = namespace = entry.getValue() == null ? "" : entry.getValue().toString().trim();
            if (namespace.length() > 0) {
                if (withNamespaces.length() > 0) {
                    withNamespaces.append(" ");
                }
                withNamespaces.append(String.valueOf(namespace) + " " + schema);
                continue;
            }
            if (withoutNamespaces != null) {
                throw new IllegalArgumentException("must not specify more than one schema without namespace: " + schemaLocations);
            }
            withoutNamespaces = schema;
        }
        if (withNamespaces.length() > 0) {
            parser.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", withNamespaces.toString());
            if (DEBUG) {
                System.err.println("withNamespaces='" + withNamespaces + "'");
            }
        }
        if (withoutNamespaces != null) {
            parser.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", withoutNamespaces);
            if (DEBUG) {
                System.err.println("withoutNamespaces='" + withoutNamespaces + "'");
            }
        }
    }

    private void setupFeaturesAndProps(XMLReader parser) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.featuresAndProperties == null || this.featuresAndProperties.size() == 0) {
            return;
        }
        Iterator iter = this.featuresAndProperties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (entry.getKey() == null) {
                throw new IllegalArgumentException("feature/property name must not be null: " + this.featuresAndProperties);
            }
            String name = entry.getKey().toString();
            Object value = entry.getValue();
            if (value instanceof Boolean) {
                parser.setFeature(name, (Boolean)value);
                continue;
            }
            parser.setProperty(name, value);
        }
    }
}

