/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.MissingResourceException;
import nu.xom.Document;
import nu.xom.ParsingException;
import nux.xom.pool.DocumentFactory;
import nux.xom.pool.DocumentMap;
import nux.xom.pool.Pool;
import nux.xom.pool.PoolConfig;
import nux.xom.pool.ResourceResolver;

public class DocumentPool {
    public static final DocumentPool GLOBAL_POOL = new DocumentPool();
    private final DocumentFactory factory;
    private final DocumentMap entries;

    public DocumentPool() {
        this(new DocumentMap(new PoolConfig()), new DocumentFactory());
    }

    public DocumentPool(DocumentMap entries, DocumentFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.factory = factory;
        if (entries == null) {
            throw new IllegalArgumentException("entries must not be null");
        }
        this.entries = entries;
    }

    public Document getDocument(File input) throws ParsingException, IOException {
        if (input == null) {
            throw new IllegalArgumentException("input must not be null");
        }
        File key = input;
        Document doc = this.entries.getDocument(key);
        if (doc == null) {
            doc = this.factory.createDocument(input);
            this.entries.putDocument(key, doc);
        }
        return doc;
    }

    public Document getDocument(URI systemID) throws ParsingException, IOException {
        if (systemID == null) {
            throw new IllegalArgumentException("systemID must not be null");
        }
        URI key = systemID;
        Document doc = this.entries.getDocument(key);
        if (doc == null) {
            doc = this.factory.createDocument(null, systemID);
            this.entries.putDocument(key, doc);
        }
        return doc;
    }

    public Document getDocument(ResourceResolver resolver, String resourceName, URI baseURI) throws ParsingException, IOException, MissingResourceException {
        if (resolver == null) {
            throw new IllegalArgumentException("resolver must not be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName must not be null");
        }
        Object key = Pool.createHashKeys(new Object[]{resourceName, baseURI});
        Document doc = this.entries.getDocument(key);
        if (doc == null) {
            InputStream input = resolver.getResourceAsStream(resourceName);
            if (input == null) {
                throw new MissingResourceException("Resource '" + resourceName + "' could not be found by resolver: " + resolver.getClass().getName(), resolver.getClass().getName(), resourceName);
            }
            doc = this.factory.createDocument(input, baseURI);
            this.entries.putDocument(key, doc);
        }
        return doc;
    }
}

