/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.MissingResourceException;
import nu.xom.Document;
import nu.xom.ParsingException;
import nu.xom.xslt.XSLException;
import nu.xom.xslt.XSLTransform;
import nux.xom.pool.Pool;
import nux.xom.pool.PoolConfig;
import nux.xom.pool.ResourceResolver;
import nux.xom.pool.XSLTransformFactory;

public class XSLTransformPool {
    public static final XSLTransformPool GLOBAL_POOL = new XSLTransformPool();
    private final XSLTransformFactory factory;
    private final Map entries;

    public XSLTransformPool() {
        this(new PoolConfig(), new XSLTransformFactory());
    }

    public XSLTransformPool(PoolConfig config, XSLTransformFactory factory) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.factory = factory;
        this.entries = Pool.createPool(config);
    }

    public XSLTransform getTransform(Document stylesheet) throws XSLException {
        if (stylesheet == null) {
            throw new IllegalArgumentException("stylesheet must not be null");
        }
        XSLTransform transform = (XSLTransform)this.entries.get(stylesheet);
        if (transform == null) {
            transform = this.factory.createTransform(stylesheet);
            this.entries.put(stylesheet, transform);
        }
        return transform;
    }

    public XSLTransform getTransform(File stylesheet) throws XSLException, ParsingException, IOException {
        if (stylesheet == null) {
            throw new IllegalArgumentException("stylesheet must not be null");
        }
        File key = stylesheet;
        XSLTransform transform = (XSLTransform)this.entries.get(key);
        if (transform == null) {
            transform = this.factory.createTransform(stylesheet);
            this.entries.put(key, transform);
        }
        return transform;
    }

    public XSLTransform getTransform(ResourceResolver resolver, String resourceName, URI baseURI) throws XSLException, ParsingException, IOException, MissingResourceException {
        if (resolver == null) {
            throw new IllegalArgumentException("resolver must not be null");
        }
        if (resourceName == null) {
            throw new IllegalArgumentException("resourceName must not be null");
        }
        Object key = Pool.createHashKeys(new Object[]{resourceName, baseURI});
        XSLTransform transform = (XSLTransform)this.entries.get(key);
        if (transform == null) {
            InputStream stylesheet = resolver.getResourceAsStream(resourceName);
            if (stylesheet == null) {
                throw new MissingResourceException("Resource '" + resourceName + "' could not be found by resolver: " + resolver.getClass().getName(), resolver.getClass().getName(), resourceName);
            }
            transform = this.factory.createTransform(stylesheet, baseURI);
            this.entries.put(key, transform);
        }
        return transform;
    }
}

