/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.WeakHashMap;

public class ThreadLocalTest
extends Thread {
    private static int counter = 0;

    public static void main(String[] args) {
        ThreadLocalTest t = new ThreadLocalTest();
        t.start();
    }

    public void run() {
        System.out.println("Starting");
        try {
            while (true) {
                this.makeNewThreadLocal();
            }
        }
        catch (OutOfMemoryError oome) {
            System.out.print("Managed to allocate and release: '" + counter);
            System.out.println("' ThreadLocals before running out of memory");
            throw oome;
        }
    }

    private void makeNewThreadLocal() {
        ThreadLocal<byte[]> t = new ThreadLocal<byte[]>();
        t.set(new byte[0x100000]);
        t.get();
        ++counter;
    }

    private static final class InitialThreadLocal
    extends ThreadLocal {
        private InitialThreadLocal() {
        }

        protected Object initialValue() {
            return new byte[0x100000];
        }
    }

    private static final class FixedThreadLocal {
        private final Map values = new WeakHashMap();

        private FixedThreadLocal() {
        }

        protected Object initialValue() {
            return null;
        }

        public final synchronized Object get() {
            Object value;
            Thread key = Thread.currentThread();
            if (!this.values.containsKey(key)) {
                value = this.initialValue();
                this.values.put(key, value);
            } else {
                value = this.values.get(key);
            }
            return value;
        }

        public final synchronized void set(Object value) {
            this.values.put(Thread.currentThread(), value);
        }
    }

    private static abstract class SoftThreadLocal
    extends ThreadLocal {
        private SoftThreadLocal() {
        }

        protected abstract Object initialSoftValue();

        protected final Object initialValue() {
            return SoftThreadLocal.wrap(this.initialSoftValue());
        }

        public Object get() {
            Object value = ((SoftReference)super.get()).get();
            if (value == null) {
                value = this.initialSoftValue();
                this.set(value);
            }
            return value;
        }

        public void set(Object value) {
            super.set(SoftThreadLocal.wrap(value));
        }

        private static SoftReference wrap(Object value) {
            return new SoftReference<Object>(value);
        }
    }
}

