/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.tests;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.HashMap;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nu.xom.Nodes;
import nu.xom.ParentNode;
import nux.xom.pool.BuilderPool;
import nux.xom.pool.FileUtil;
import nux.xom.pool.XOMUtil;
import nux.xom.xquery.ResultSequenceSerializer;
import nux.xom.xquery.XQuery;
import nux.xom.xquery.XQueryException;
import nux.xom.xquery.XQueryUtil;

public class XQueryTestSuiteW3C {
    private static final Charset UTF8 = Charset.forName("UTF-8");
    private static final boolean DISABLE_URI_CHECK = true;

    private XQueryTestSuiteW3C() {
    }

    public static void main(String[] args) throws Throwable {
        new XQueryTestSuiteW3C().run(args);
    }

    private void run(String[] args) throws Throwable {
        File rootDir;
        System.setProperty("nu.xom.Verifier.checkURI", "false");
        if (args.length == 0) {
            args = new String[]{"../xqts-0.9.4"};
        }
        if (!(rootDir = new File(args[0])).exists() || !rootDir.isDirectory()) {
            throw new IllegalArgumentException("xqts dir does not exist: " + rootDir);
        }
        Document catalog = this.buildDocument(new File(rootDir, "XQTSCatalog.xml"));
        String ns = "declare namespace ns = 'http://www.w3.org/2005/02/query-test-XQTSCatalog'; ";
        File expectedDir = new File(rootDir, XQueryUtil.xquery((Node)catalog, String.valueOf(ns) + "ns:test-suite/@ResultOffsetPath").get(0).getValue());
        File queryDir = new File(rootDir, XQueryUtil.xquery((Node)catalog, String.valueOf(ns) + "ns:test-suite/@XQueryQueryOffsetPath").get(0).getValue());
        File testSourcesDir = new File(rootDir, "TestSources");
        Nodes testCases = XQueryUtil.xquery((Node)catalog, String.valueOf(ns) + "//ns:test-case");
        int i = 0;
        while (i < testCases.size()) {
            block24: {
                Node testCase = testCases.get(i);
                String path = XQueryUtil.xquery(testCase, "@FilePath").get(0).getValue();
                File query = new File(new File(queryDir, path), String.valueOf(XQueryUtil.xquery(testCase, String.valueOf(ns) + "ns:query/@name").get(0).getValue()) + ".xq");
                String squery = this.readQuery(query);
                System.out.println(String.valueOf(i) + ": " + query + " ...");
                if (XQueryUtil.xquery(testCase, String.valueOf(ns) + "ns:spec-citation[@section-pointer='id-validate']").size() > 0) {
                    System.out.println("\t\t************* IGNORED SCHEMA AWARE FUNCTIONALITY *****");
                } else if (squery == null) {
                    System.out.println("\t\t************* IGNORED *****");
                } else {
                    Nodes inputs = XQueryUtil.xquery(testCase, String.valueOf(ns) + "ns:input-file");
                    HashMap<String, Document> vars = new HashMap<String, Document>();
                    int j = 0;
                    while (j < inputs.size()) {
                        File input = new File(testSourcesDir, String.valueOf(inputs.get(j).getValue()) + ".xml");
                        String varName = ((Element)inputs.get(j)).getAttributeValue("variable");
                        Document inputDoc = this.buildDocument(input);
                        XOMUtil.Normalizer.STRIP.normalize((ParentNode)inputDoc);
                        vars.put(varName, inputDoc);
                        ++j;
                    }
                    Nodes expectedErrors = XQueryUtil.xquery(testCase, String.valueOf(ns) + "ns:expected-error");
                    Nodes expectedOutputs = XQueryUtil.xquery(testCase, String.valueOf(ns) + "ns:output-file");
                    boolean inspect = false;
                    int k = 0;
                    while (!inspect && k < expectedOutputs.size()) {
                        String compare = ((Element)expectedOutputs.get(k)).getAttributeValue("compare");
                        if ("Inspect".equals(compare)) {
                            inspect = true;
                        }
                        ++k;
                    }
                    Nodes results = null;
                    try {
                        XQuery xquery = new XQuery(squery, testSourcesDir.toURI());
                        results = xquery.execute(null, null, vars).toNodes();
                    }
                    catch (Throwable t) {
                        if (!inspect && expectedErrors.size() == 0) {
                            System.out.println(XOMUtil.toPrettyXML(testCase));
                            throw t;
                        }
                        if (!(t instanceof XQueryException)) {
                            throw t;
                        }
                        break block24;
                    }
                    int k2 = 0;
                    while (k2 < expectedOutputs.size()) {
                        File expectedOutput = new File(new File(expectedDir, path), expectedOutputs.get(k2).getValue());
                        String compare = ((Element)expectedOutputs.get(k2)).getAttributeValue("compare");
                        if ("Text".equals(compare)) {
                            compare = "Fragment";
                        }
                        try {
                            String actual;
                            String expected;
                            if (compare.equals("Text")) {
                                expected = FileUtil.toString(new FileInputStream(expectedOutput), UTF8);
                                actual = this.serialize(results);
                                this.assertEquals(expected, actual);
                                break;
                            }
                            if (compare.equals("XML")) {
                                expected = this.buildDocument(expectedOutput);
                                if (query.toString().indexOf("XQuery/UseCase/") >= 0) {
                                    XOMUtil.Normalizer.STRIP.normalize((ParentNode)expected);
                                }
                                actual = XOMUtil.toDocument(this.serialize(results));
                                this.assertEquals((Document)expected, (Document)actual);
                                break;
                            }
                            if (compare.equals("Fragment")) {
                                expected = this.buildFromSequence(expectedOutput);
                                actual = this.buildFromSequence(results);
                                this.assertEquals((Document)expected, (Document)actual);
                                break;
                            }
                            if (compare.equals("Ignore")) break;
                            if (compare.equals("Inspect")) {
                                System.out.println("****************** Inspect output?");
                                break;
                            }
                            throw new RuntimeException("Unrecognized comparison operator: " + compare);
                        }
                        catch (ConformanceException e) {
                            if (k2 == expectedOutputs.size() - 1) {
                                System.out.println(XOMUtil.toPrettyXML(testCase));
                                throw e;
                            }
                            ++k2;
                        }
                    }
                }
            }
            ++i;
        }
        System.out.println("\nFinished testing. Good bye.");
    }

    private void assertEquals(String expected, String actual) {
        if (!this.normalize(expected).equals(this.normalize(actual))) {
            this.fail(expected, actual);
        }
    }

    private void assertEquals(Document expected, Document actual) throws UnsupportedEncodingException {
        byte[] a;
        int window = 20;
        byte[] e = XOMUtil.toCanonicalXML(expected);
        if (!Arrays.equals(e, a = XOMUtil.toCanonicalXML(actual))) {
            if (e.length != a.length) {
                System.out.println("e.length=" + e.length + ", a.length=" + a.length);
            }
            int size = Math.min(e.length, a.length);
            int i = 0;
            while (i < size) {
                if (e[i] != a[i]) {
                    System.out.println("diff at i=" + i + ", e[i]=" + e[i] + ", a[i]=" + a[i]);
                    int off = Math.max(0, i - window);
                    int len1 = Math.min(2 * window, e.length - off);
                    int len2 = Math.min(2 * window, a.length - off);
                    System.out.println("e='" + new String(e, off, len1, "UTF-8") + "'");
                    System.out.println("a='" + new String(a, off, len2, "UTF-8") + "'");
                    break;
                }
                ++i;
            }
            this.fail(expected.toXML(), actual.toXML());
        }
    }

    private void fail(Object expected, Object actual) {
        throw new ConformanceException("\nexpected='" + expected + "', \nactual  ='" + actual + "'");
    }

    private String normalize(String text) {
        Element wrapper = new Element("dummy");
        wrapper.appendChild(text);
        XOMUtil.Normalizer.COLLAPSE.normalize((ParentNode)wrapper);
        return wrapper.getValue();
    }

    private Document buildDocument(File file) throws Exception {
        return BuilderPool.GLOBAL_POOL.getBuilder(false).build(file);
    }

    private Document buildFromSequence(File file) {
        String xml = "<!DOCTYPE doc [<!ENTITY e SYSTEM '" + file.toURI() + "'>]><doc>&e;</doc>";
        Document doc = XOMUtil.toDocument(xml);
        XOMUtil.Normalizer.COLLAPSE.normalize((ParentNode)doc);
        return doc;
    }

    private Document buildFromSequence(Nodes nodes) throws IOException {
        File tmp = new File(System.getProperty("java.io.tmpdir"));
        tmp = new File(tmp, "xqts-tmp.out");
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(tmp), UTF8);
        out.write(this.serialize(nodes));
        ((Writer)out).flush();
        ((Writer)out).close();
        Document doc = this.buildFromSequence(tmp);
        tmp.delete();
        return doc;
    }

    private String serialize(Nodes nodes) {
        String xml;
        ResultSequenceSerializer serializer = new ResultSequenceSerializer();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            serializer.write(nodes, out);
            xml = out.toString("UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException("should never happen", e);
        }
        xml = xml.substring(xml.indexOf(62) + 1);
        if (xml.startsWith("\r\n")) {
            xml = xml.substring(2);
        }
        int j = xml.length();
        if (xml.endsWith("\r\n")) {
            j -= 2;
        } else if (xml.endsWith("\n")) {
            --j;
        }
        return xml.substring(0, j);
    }

    private String readQuery(File query) throws IOException {
        if (this.ignore(query)) {
            return null;
        }
        String squery = FileUtil.toString(new FileInputStream(query), UTF8);
        return this.substituteSchema(squery);
    }

    private String substituteSchema(String query) {
        String toFind = "import schema default element namespace";
        int i = query.indexOf(toFind);
        if (i >= 0) {
            System.out.println("************* Substituting 'import schema default element namespace' with 'declare default element namespace'.");
            System.out.println("before='" + query + "'");
            query = String.valueOf(query.substring(0, i)) + "declare default element namespace" + query.substring(i + toFind.length());
            System.out.println("after='" + query + "'");
        }
        if ((i = query.indexOf(toFind = "import schema namespace")) >= 0) {
            System.out.println("************* Substituting 'import schema namespace' with 'declare namespace'.");
            System.out.println("before='" + query + "'");
            query = String.valueOf(query.substring(0, i)) + "declare namespace" + query.substring(i + toFind.length());
            System.out.println("after='" + query + "'");
        }
        if ((i = query.indexOf(toFind = "import schema")) >= 0) {
            System.out.println("************* Substituting 'import schema' with 'declare default element namespace'.");
            System.out.println("before='" + query + "'");
            if (query.indexOf("declare default element namespace") < 0) {
                query = String.valueOf(query.substring(0, i)) + "declare default element namespace" + query.substring(i + toFind.length());
            } else {
                int j = query.indexOf(59, i);
                query = String.valueOf(query.substring(0, i)) + query.substring(j + 1);
            }
            System.out.println("after='" + query + "'");
        }
        return query;
    }

    private boolean ignore(File query) {
        String s = query.toString();
        if (XQueryTestSuiteW3C.endsWith(s, "ConDocNode/Constr-docnode-nested-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ConDocNode/Constr-docnode-enclexpr-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ConDocNode/Constr-docnode-enclexpr-2.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ConDocNode/Constr-docnode-enclexpr-3.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ConDocNode/Constr-docnode-enclexpr-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ConDocNode/Constr-docnode-doc-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ConText/Constr-text-nested-3.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ComputeConComment/Constr-compcomment-nested-3.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DirectConElemContent/Constr-cont-constrmod-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DirectConElemContent/Constr-cont-constrmod-8.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ComputeConElem/Constr-compelem-compname-9.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ComputeConAttr/Constr-compattr-compname-9.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ComputeConComment/Constr-compcomment-dash-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ComputeConComment/Constr-compcomment-doubledash-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Catalog/Catalog001.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Catalog/Catalog002.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Catalog/Catalog003.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ForExprType/ForExprType009.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ForExprType/ForExprType009-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ForExprType/ForExprType010.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ForExprType/ForExprType024.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ForExprType/ForExprType025.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ForExprType/ForExprType026.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ForExprType/ForExprType027.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ForExprType/ForExprType038.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ForExprType/ForExprType039.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "ForExprType/ForExprType04")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "ForExprType/ForExprType05")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "QNameFunc/QNameConstructFunc/ExpandedQNameConstructFunc/ExpandedQNameConstructFunc018.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "QNameFunc/LocalNameFromQnameFunc/")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "QNameFunc/NamespaceURIFromQNameFunc/")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NamespaceProlog/namespaceDecl-17.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NamespaceProlog/namespaceDecl-20.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NamespaceProlog/namespaceDecl-21.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NamespaceProlog/namespaceDecl-23.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DocumentURIFunc/fn-document-uri-12.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DocumentURIFunc/fn-document-uri-15.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DocumentURIFunc/fn-document-uri-16.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "DocumentURIFunc")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqIDFunc/fn-id-5.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "NodeSeqFunc/SeqIDFunc/fn-id-")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DirectConElemContent/Constr-cont-constrmod-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DirectConElemContent/Constr-cont-nsmode-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DirectConElem/DirectConElemContent/Constr-cont-nsmode-3.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DirectConElem/DirectConElemContent/Constr-cont-nsmode-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NotationOp/NotationEQ/Comp-notation-5.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NotationOp/NotationEQ/Comp-notation-8.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NotationOp/NotationEQ/Comp-notation-10.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "NotationOp/NotationEQ/")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqOp/SeqExcept/fn-except-node-args-003.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "VariableProlog/ExternalVariablesWithout/extvardeclwithouttype-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "VariableProlog/ExternalVariablesWithout/extvardeclwithouttype-2.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "VariableProlog/ExternalVariablesWithout/")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "VariableProlog/ExternalVariablesWith/")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "AllStringFunc/MatchStringFunc/MatchesFunc/caselessmatch04.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqIDREFFunc/fn-idref-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqIDREFFunc/fn-idref-5.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqIDREFFunc/fn-idref-6.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "/SeqIDREFFunc/fn-idref-")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ModuleImport/modules-two-import-ok.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "UseCaseSEQ/seq-queries-results-q5.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NodeNumberFunc/fn-numberflt1args-3.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NodeNumberFunc/fn-numbernpi1args-2.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "FilterExpr/filterexpressionhc5.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "QNameOp/PrefixFromQName/fn-prefix-from-qname-3.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "FLWORExpr/ForExpr/ForExpr005.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "FLWORExpr/ReturnExpr/ReturnExpr004.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqExprCast/qname-cast-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqExprCast/qname-cast-2.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqExprCast/qname-cast-3.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqExprCast/qname-cast-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqExprCast/notation-cast-3.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "FunctionDeclaration/function-declaration-008.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "FunctionDeclaration/function-declaration-009.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NilledFunc/fn-nilled-5.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NilledFunc/fn-nilled-7.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NilledFunc/fn-nilled-12.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NilledFunc/fn-nilled-15.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NilledFunc/fn-nilled-16.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NilledFunc/fn-nilled-17.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NilledFunc/fn-nilled-23.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DurationDateTimeFunc/SecondsFromDateTimeFunc/fn-seconds-from-dateTime-13.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "AggregateSeqFunc/SeqMAXFunc/fn-max-2.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "AggregateSeqFunc/SeqMINFunc/fn-min-2.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "TrivialEmbedding/trivial-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "TrivialEmbedding/trivial-3.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "FilterExpr/K-FilterExpr-91.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NumericAdd/K-NumericAdd-5.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "NumericAdd/K-NumericAdd-6.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DurationDateTimeOp/TimeGT/op-time-greater-than-2.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "CompExpr/GenComprsn/GenCompLT/K-GenCompLT-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "CompExpr/NodeComp/NodeBefore/K-NodeBefore-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "seqExprTypes/SeqExprCast/K-SeqExprCast-70.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "seqExprTypes/SeqExprCast/K-SeqExprCast-394.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "seqExprTypes/SeqExprCast/K-SeqExprCast-396.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "seqExprTypes/SeqExprCast/K-SeqExprCast-959.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "seqExprTypes/SeqExprCast/K-SeqExprCast-1427.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "seqExprTypes/SeqExprCastable/K-SeqExprCastable-19.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "seqExprTypes/SeqExprCastable/K-SeqExprCastable-21.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "exprSeqTypes/SeqExprCastable/CastableAs647.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "PrologExpr/FunctionProlog/K-FunctionProlog-1.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "PrologExpr/FunctionProlog/K-FunctionProlog-66.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ExtensionExpression/K-ExtensionExpression-6.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "ExtensionExpression/K-ExtensionExpression-8.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "DurationDateTimeFunc/SecondsFromDurationFunc/fn-seconds-from-duration-20.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqSubsequenceFunc/K-SeqSubsequenceFunc-21.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqDeepEqualFunc/K-SeqDeepEqualFunc-8.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqDeepEqualFunc/K-SeqDeepEqualFunc-9.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqDeepEqualFunc/K-SeqDeepEqualFunc-10.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqDeepEqualFunc/K-SeqDeepEqualFunc-11.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqMAXFunc/K-SeqMAXFunc-13.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqMAXFunc/K-SeqMAXFunc-15.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqMINFunc/K-SeqMINFunc-13.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SeqMINFunc/K-SeqMINFunc-15.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "SchemaImport/SchemaImportProlog/modules-schema-context.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Modules/ModuleImport/modules-simple.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Modules/ModuleImport/modules-2.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Modules/ModuleImport/modules-4.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Modules/ModuleImport/modules-5.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Modules/ModuleImport/modules-6.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Modules/ModuleImport/modules-7.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Modules/ModuleImport/modules-8.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.endsWith(s, "Modules/ModuleImport/modules-9.xq")) {
            return true;
        }
        if (XQueryTestSuiteW3C.contains(s, "Modules/ModuleImport/modules-1")) {
            return true;
        }
        return XQueryTestSuiteW3C.endsWith(s, "UseCase/UseCaseR/rdb-queries-results-q4.xq");
    }

    protected static boolean endsWith(String x, String y) {
        x = x.replace('/', File.separatorChar);
        x = x.replace('\\', File.separatorChar);
        y = y.replace('/', File.separatorChar);
        y = y.replace('\\', File.separatorChar);
        return x.endsWith(y);
    }

    protected static boolean contains(String x, String y) {
        x = x.replace('/', File.separatorChar);
        x = x.replace('\\', File.separatorChar);
        y = y.replace('/', File.separatorChar);
        return x.indexOf(y = y.replace('\\', File.separatorChar)) >= 0;
    }

    private static final class ConformanceException
    extends RuntimeException {
        private ConformanceException(String msg) {
            super(msg);
        }
    }
}

