/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index.memory;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.index.memory.PatternAnalyzer;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;

public class MemoryIndexTest
extends TestCase {
    private Analyzer analyzer;
    private boolean fastMode = false;
    private static final String FIELD_NAME = "content";
    private static final Charset DEFAULT_PLATFORM_CHARSET = Charset.forName(new InputStreamReader(new ByteArrayInputStream(new byte[0])).getEncoding());

    public static void main(String[] args) throws Throwable {
        new MemoryIndexTest().run(args);
    }

    public void testMany() throws Throwable {
        String[] files = MemoryIndexTest.listFiles(new String[]{"*.txt", "*.html", "*.xml", "xdocs/*.xml", "src/java/test/org/apache/lucene/queryParser/*.java", "src/java/org/apache/lucene/index/memory/*.java"});
        System.out.println("files = " + Arrays.asList(files));
        String[] xargs = new String[]{"1", "1", "memram", "@src/test/org/apache/lucene/index/memory/testqueries.txt"};
        String[] args = new String[xargs.length + files.length];
        System.arraycopy(xargs, 0, args, 0, xargs.length);
        System.arraycopy(files, 0, args, xargs.length, files.length);
        this.run(args);
    }

    private void run(String[] args) throws Throwable {
        int k = -1;
        int iters = 1;
        if (args.length > ++k) {
            iters = Math.max(1, Integer.parseInt(args[k]));
        }
        int runs = 1;
        if (args.length > ++k) {
            runs = Math.max(1, Integer.parseInt(args[k]));
        }
        String cmd = "memram";
        if (args.length > ++k) {
            cmd = args[k];
        }
        boolean useMemIndex = cmd.indexOf("mem") >= 0;
        boolean useRAMIndex = cmd.indexOf("ram") >= 0;
        String[] queries = new String[]{"term", "term*", "term~", "Apache", "Apach~ AND Copy*"};
        if (args.length > ++k) {
            String arg = args[k];
            queries = arg.startsWith("@") ? this.readLines(new File(arg.substring(1))) : new String[]{arg};
        }
        File[] files = new File[]{new File("CHANGES.txt"), new File("LICENSE.txt")};
        if (args.length > ++k) {
            files = new File[args.length - k];
            int i = k;
            while (i < args.length) {
                files[i - k] = new File(args[i]);
                ++i;
            }
        }
        boolean toLowerCase = true;
        Set stopWords = StopFilter.makeStopSet((String[])StopAnalyzer.ENGLISH_STOP_WORDS);
        Analyzer[] analyzers = new Analyzer[]{new SimpleAnalyzer(), new StopAnalyzer(), new StandardAnalyzer(), PatternAnalyzer.DEFAULT_ANALYZER};
        int iter = 0;
        while (iter < iters) {
            System.out.println("\n########### iteration=" + iter);
            long start = System.currentTimeMillis();
            long bytes = 0L;
            int anal = 0;
            while (anal < analyzers.length) {
                this.analyzer = analyzers[anal];
                int i = 0;
                while (i < files.length) {
                    File file = files[i];
                    if (file.exists() && !file.isDirectory()) {
                        bytes += file.length();
                        String text = MemoryIndexTest.toString(new FileInputStream(file), null);
                        Document doc = this.createDocument(text);
                        System.out.println("\n*********** FILE=" + file);
                        int q = 0;
                        while (q < queries.length) {
                            try {
                                Query query = this.parseQuery(queries[q]);
                                int run = 0;
                                while (run < runs) {
                                    float score1 = 0.0f;
                                    float score2 = 0.0f;
                                    if (useMemIndex) {
                                        score1 = this.query(this.createMemoryIndex(doc), query);
                                    }
                                    if (useRAMIndex) {
                                        score2 = this.query(this.createRAMIndex(doc), query);
                                    }
                                    if (useMemIndex && useRAMIndex) {
                                        System.out.println("diff=" + (score1 - score2) + ", query=" + queries[q] + ", s1=" + score1 + ", s2=" + score2);
                                        if (score1 != score2 || score1 < 0.0f || score2 < 0.0f || score1 > 1.0f || score2 > 1.0f) {
                                            throw new IllegalStateException("BUG DETECTED:" + i * (q + 1) + " at query=" + queries[q] + ", file=" + file + ", anal=" + this.analyzer);
                                        }
                                    }
                                    ++run;
                                }
                            }
                            catch (Throwable t) {
                                if (t instanceof OutOfMemoryError) {
                                    t.printStackTrace();
                                }
                                System.out.println("Fatal error at query=" + queries[q] + ", file=" + file + ", anal=" + this.analyzer);
                                throw t;
                            }
                            ++q;
                        }
                    }
                    ++i;
                }
                ++anal;
            }
            long end = System.currentTimeMillis();
            System.out.println("\nsecs = " + (float)(end - start) / 1000.0f);
            System.out.println("queries/sec= " + 1.0f * (float)runs * (float)queries.length * (float)analyzers.length * (float)files.length / ((float)(end - start) / 1000.0f));
            float mb = 1.0f * (float)bytes * (float)queries.length * (float)runs / 1048576.0f;
            System.out.println("MB/sec = " + mb / ((float)(end - start) / 1000.0f));
            ++iter;
        }
        if (useMemIndex && useRAMIndex) {
            System.out.println("No bug found. done.");
        } else {
            System.out.println("Done benchmarking (without checking correctness).");
        }
    }

    private String[] readLines(File file) throws Exception {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            String t = line.trim();
            if (t.length() <= 0 || t.charAt(0) == '#' || t.startsWith("//")) continue;
            lines.add(line);
        }
        reader.close();
        String[] result = new String[lines.size()];
        lines.toArray(result);
        return result;
    }

    private Document createDocument(String content) {
        Document doc = new Document();
        doc.add(new Field(FIELD_NAME, content, Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.WITH_POSITIONS));
        return doc;
    }

    private MemoryIndex createMemoryIndex(Document doc) {
        MemoryIndex index = new MemoryIndex();
        Enumeration iter = doc.fields();
        while (iter.hasMoreElements()) {
            Field field = (Field)iter.nextElement();
            index.addField(field.name(), field.stringValue(), this.analyzer);
        }
        return index;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private RAMDirectory createRAMIndex(Document doc) {
        RAMDirectory rAMDirectory;
        RAMDirectory dir = new RAMDirectory();
        IndexWriter writer = null;
        try {
            try {
                writer = new IndexWriter((Directory)dir, this.analyzer, true);
                writer.setMaxFieldLength(Integer.MAX_VALUE);
                writer.addDocument(doc);
                writer.optimize();
                rAMDirectory = dir;
                Object var5_5 = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        try {}
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        if (writer == null) return rAMDirectory;
        writer.close();
        return rAMDirectory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private float query(Object index, Query query) {
        float f;
        IndexSearcher searcher = null;
        try {
            try {
                float score;
                searcher = index instanceof Directory ? new IndexSearcher((Directory)index) : ((MemoryIndex)index).createSearcher();
                final float[] scores = new float[1];
                searcher.search(query, new HitCollector(){

                    public void collect(int doc, float score) {
                        scores[0] = score;
                    }
                });
                f = score = scores[0];
                Object var6_8 = null;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            try {
                if (searcher == null) throw throwable;
                searcher.close();
                throw throwable;
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        }
        try {}
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
        if (searcher == null) return f;
        searcher.close();
        return f;
    }

    private int getMemorySize(Object index) {
        if (index instanceof Directory) {
            try {
                Directory dir = (Directory)index;
                int size = 0;
                String[] fileNames = dir.list();
                int i = 0;
                while (i < fileNames.length) {
                    size = (int)((long)size + dir.fileLength(fileNames[i]));
                    ++i;
                }
                return size;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return ((MemoryIndex)index).getMemorySize();
    }

    private Query parseQuery(String expression) throws ParseException {
        QueryParser parser = new QueryParser(FIELD_NAME, this.analyzer);
        return parser.parse(expression);
    }

    static String[] listFiles(String[] fileNames) {
        LinkedHashSet<String> allFiles = new LinkedHashSet<String>();
        int i = 0;
        while (i < fileNames.length) {
            int k = fileNames[i].indexOf("*");
            if (k < 0) {
                allFiles.add(fileNames[i]);
            } else {
                String suffix;
                File[] files;
                String prefix = fileNames[i].substring(0, k);
                if (prefix.length() == 0) {
                    prefix = ".";
                }
                if ((files = new File(prefix).listFiles(new FilenameFilter(suffix = fileNames[i].substring(k + 1)){
                    private final /* synthetic */ String val$suffix;
                    {
                        this.val$suffix = string;
                    }

                    public boolean accept(File dir, String name) {
                        return name.endsWith(this.val$suffix);
                    }
                })) != null) {
                    int j = 0;
                    while (j < files.length) {
                        allFiles.add(files[j].getPath());
                        ++j;
                    }
                }
            }
            ++i;
        }
        String[] result = new String[allFiles.size()];
        allFiles.toArray(result);
        return result;
    }

    private static String toString(InputStream input, Charset charset) throws IOException {
        if (charset == null) {
            charset = DEFAULT_PLATFORM_CHARSET;
        }
        byte[] data = MemoryIndexTest.toByteArray(input);
        return charset.decode(ByteBuffer.wrap(data)).toString();
    }

    private static byte[] toByteArray(InputStream input) throws IOException {
        byte[] byArray;
        block8: {
            byte[] output;
            byte[] buffer;
            int len;
            block6: {
                byte[] byArray2;
                block7: {
                    try {
                        int n;
                        len = Math.max(256, input.available());
                        buffer = new byte[len];
                        output = new byte[len];
                        len = 0;
                        while ((n = input.read(buffer)) >= 0) {
                            if (len + n > output.length) {
                                byte[] tmp = new byte[Math.max(output.length << 1, len + n)];
                                System.arraycopy(output, 0, tmp, 0, len);
                                System.arraycopy(buffer, 0, tmp, len, n);
                                buffer = output;
                                output = tmp;
                            } else {
                                System.arraycopy(buffer, 0, output, len, n);
                            }
                            len += n;
                        }
                        if (len != output.length) break block6;
                        byArray2 = output;
                        Object var6_8 = null;
                        if (input == null) break block7;
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var6_10 = null;
                            if (input == null) break block9;
                            input.close();
                        }
                        throw throwable;
                    }
                    input.close();
                }
                return byArray2;
            }
            buffer = null;
            buffer = new byte[len];
            System.arraycopy(output, 0, buffer, 0, len);
            byArray = buffer;
            Object var6_9 = null;
            if (input == null) break block8;
            input.close();
        }
        return byArray;
    }
}

