/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.ArrayList;
import java.util.List;

public class Proj4FileReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] readParametersFromFile(String authorityCode, String name) throws IOException {
        String[] args;
        String filename = "/nad/" + authorityCode.toLowerCase();
        InputStream inStr = Proj4FileReader.class.getResourceAsStream(filename);
        if (inStr == null) {
            throw new IllegalStateException("Unable to access CRS file: " + filename);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inStr));
        try {
            args = this.readFile(reader, name);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return args;
    }

    private StreamTokenizer createTokenizer(BufferedReader reader) {
        StreamTokenizer t = new StreamTokenizer(reader);
        t.commentChar(35);
        t.ordinaryChars(48, 57);
        t.ordinaryChars(46, 46);
        t.ordinaryChars(45, 45);
        t.ordinaryChars(43, 43);
        t.wordChars(48, 57);
        t.wordChars(39, 39);
        t.wordChars(34, 34);
        t.wordChars(95, 95);
        t.wordChars(46, 46);
        t.wordChars(45, 45);
        t.wordChars(43, 43);
        t.wordChars(44, 44);
        t.wordChars(64, 64);
        return t;
    }

    private String[] readFile(BufferedReader reader, String name) throws IOException {
        StreamTokenizer t = this.createTokenizer(reader);
        t.nextToken();
        while (t.ttype == 60) {
            t.nextToken();
            if (t.ttype != -3) {
                throw new IOException(t.lineno() + ": Word expected after '<'");
            }
            String crsName = t.sval;
            t.nextToken();
            if (t.ttype != 62) {
                throw new IOException(t.lineno() + ": '>' expected");
            }
            t.nextToken();
            ArrayList v = new ArrayList();
            while (t.ttype != 60) {
                if (t.ttype == 43) {
                    t.nextToken();
                }
                if (t.ttype != -3) {
                    throw new IOException(t.lineno() + ": Word expected after '+'");
                }
                String key = t.sval;
                t.nextToken();
                if (t.ttype == 61) {
                    t.nextToken();
                    String value = t.sval;
                    t.nextToken();
                    Proj4FileReader.addParam(v, key, value);
                    continue;
                }
                Proj4FileReader.addParam(v, key, null);
            }
            t.nextToken();
            if (t.ttype != 62) {
                throw new IOException(t.lineno() + ": '<>' expected");
            }
            t.nextToken();
            if (!crsName.equals(name)) continue;
            String[] args = v.toArray(new String[0]);
            return args;
        }
        return null;
    }

    private static void addParam(List v, String key, String value) {
        String plusKey = key;
        if (!key.startsWith("+")) {
            plusKey = "+" + key;
        }
        if (value != null) {
            v.add(plusKey + "=" + value);
        } else {
            v.add(plusKey);
        }
    }

    public String[] getParameters(String crsName) {
        try {
            int p = crsName.indexOf(58);
            if (p >= 0) {
                String auth = crsName.substring(0, p);
                String id = crsName.substring(p + 1);
                return this.readParametersFromFile(auth, id);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

