/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class BipolarProjection
extends Projection {
    private boolean noskew;
    private static final double EPS = 1.0E-10;
    private static final double EPS10 = 1.0E-10;
    private static final double ONEEPS = 1.000000001;
    private static final int NITER = 10;
    private static final double lamB = -0.3489497672625068;
    private static final double n = 0.6305584488127469;
    private static final double F = 1.8972474256746104;
    private static final double Azab = 0.8165004367468637;
    private static final double Azba = 1.8226184385618593;
    private static final double T = 1.27246578267089;
    private static final double rhoc = 1.2070912152156872;
    private static final double cAzc = 0.6969152303867837;
    private static final double sAzc = 0.7171535133114361;
    private static final double C45 = 0.7071067811865476;
    private static final double S45 = 0.7071067811865476;
    private static final double C20 = 0.9396926207859084;
    private static final double S20 = -0.3420201433256687;
    private static final double R110 = 1.9198621771937625;
    private static final double R104 = 1.8151424220741028;

    public BipolarProjection() {
        this.minLatitude = Math.toRadians(-80.0);
        this.maxLatitude = Math.toRadians(80.0);
        this.projectionLongitude = Math.toRadians(-90.0);
        this.minLongitude = Math.toRadians(-90.0);
        this.maxLongitude = Math.toRadians(90.0);
    }

    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        double d;
        double d2;
        double Av;
        double z;
        boolean tag;
        double tphi;
        double Az;
        double cphi = Math.cos(lpphi);
        double sphi = Math.sin(lpphi);
        double sdlam = -0.3489497672625068 - lplam;
        double cdlam = Math.cos(sdlam);
        sdlam = Math.sin(sdlam);
        if (Math.abs(Math.abs(lpphi) - 1.5707963267948966) < 1.0E-10) {
            Az = lpphi < 0.0 ? Math.PI : 0.0;
            tphi = Double.MAX_VALUE;
        } else {
            tphi = sphi / cphi;
            Az = Math.atan2(sdlam, 0.7071067811865476 * (tphi - cdlam));
        }
        if (tag = Az > 1.8226184385618593) {
            sdlam = lplam + 1.9198621771937625;
            cdlam = Math.cos(sdlam);
            sdlam = Math.sin(sdlam);
            z = -0.3420201433256687 * sphi + 0.9396926207859084 * cphi * cdlam;
            if (Math.abs(z) > 1.0) {
                if (Math.abs(z) > 1.000000001) {
                    throw new ProjectionException("F");
                }
                z = z < 0.0 ? -1.0 : 1.0;
            } else {
                z = Math.acos(z);
            }
            if (tphi != Double.MAX_VALUE) {
                Az = Math.atan2(sdlam, 0.9396926207859084 * tphi - -0.3420201433256687 * cdlam);
            }
            Av = 0.8165004367468637;
            out.y = 1.2070912152156872;
        } else {
            z = 0.7071067811865476 * (sphi + cphi * cdlam);
            if (Math.abs(z) > 1.0) {
                if (Math.abs(z) > 1.000000001) {
                    throw new ProjectionException("F");
                }
                z = z < 0.0 ? -1.0 : 1.0;
            } else {
                z = Math.acos(z);
            }
            Av = 1.8226184385618593;
            out.y = -1.2070912152156872;
        }
        if (z < 0.0) {
            throw new ProjectionException("F");
        }
        double t = Math.pow(Math.tan(0.5 * z), 0.6305584488127469);
        double r = 1.8972474256746104 * t;
        double al = 0.5 * (1.8151424220741028 - z);
        if (d2 < 0.0) {
            throw new ProjectionException("F");
        }
        if (Math.abs(al = (t + Math.pow(al, 0.6305584488127469)) / 1.27246578267089) > 1.0) {
            if (Math.abs(al) > 1.000000001) {
                throw new ProjectionException("F");
            }
            al = al < 0.0 ? -1.0 : 1.0;
        } else {
            al = Math.acos(al);
        }
        t = 0.6305584488127469 * (Av - Az);
        if (Math.abs(d) < al) {
            r /= Math.cos(al + (tag ? t : -t));
        }
        out.x = r * Math.sin(t);
        out.y = out.y + (tag ? -r : r) * Math.cos(t);
        if (this.noskew) {
            t = out.x;
            out.x = -out.x * 0.6969152303867837 - out.y * 0.7171535133114361;
            out.y = -out.y * 0.6969152303867837 + t * 0.7171535133114361;
        }
        return out;
    }

    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        int i;
        double r;
        double Av;
        double c;
        double s;
        boolean neg;
        double z = 0.0;
        if (this.noskew) {
            double t = xyx;
            out.x = -xyx * 0.6969152303867837 + xyy * 0.7171535133114361;
            out.y = -xyy * 0.6969152303867837 - t * 0.7171535133114361;
        }
        if (neg = xyx < 0.0) {
            out.y = 1.2070912152156872 - xyy;
            s = -0.3420201433256687;
            c = 0.9396926207859084;
            Av = 0.8165004367468637;
        } else {
            out.y += 1.2070912152156872;
            s = 0.7071067811865476;
            c = 0.7071067811865476;
            Av = 1.8226184385618593;
        }
        double rp = r = ProjectionMath.distance(xyx, xyy);
        double rl = r;
        double Az = Math.atan2(xyx, xyy);
        double fAz = Math.abs(Az);
        for (i = 10; i > 0; --i) {
            z = 2.0 * Math.atan(Math.pow(r / 1.8972474256746104, 1.585895806935677));
            double al = Math.acos((Math.pow(Math.tan(0.5 * z), 0.6305584488127469) + Math.pow(Math.tan(0.5 * (1.8151424220741028 - z)), 0.6305584488127469)) / 1.27246578267089);
            if (fAz < al) {
                r = rp * Math.cos(al + (neg ? Az : -Az));
            }
            if (Math.abs(rl - r) < 1.0E-10) break;
            rl = r;
        }
        if (i == 0) {
            throw new ProjectionException("I");
        }
        Az = Av - Az / 0.6305584488127469;
        out.y = Math.asin(s * Math.cos(z) + c * Math.sin(z) * Math.cos(Az));
        out.x = Math.atan2(Math.sin(Az), c / Math.tan(z) - s * Math.cos(Az));
        out.x = neg ? (out.x -= 1.9198621771937625) : -0.3489497672625068 - out.x;
        return out;
    }

    public boolean hasInverse() {
        return true;
    }

    public void initialize() {
        super.initialize();
    }

    public String toString() {
        return "Bipolar Conic of Western Hemisphere";
    }
}

