/*
 * Decompiled with CFR 0.152.
 */
package org.osgeo.proj4j.proj;

import org.osgeo.proj4j.ProjCoordinate;
import org.osgeo.proj4j.ProjectionException;
import org.osgeo.proj4j.proj.Projection;
import org.osgeo.proj4j.util.ProjectionMath;

public class BonneProjection
extends Projection {
    private double phi1;
    private double cphi1;
    private double am1;
    private double m1;
    private double[] en;

    public ProjCoordinate project(double lplam, double lpphi, ProjCoordinate out) {
        if (this.spherical) {
            double rh = this.cphi1 + this.phi1 - lpphi;
            if (Math.abs(rh) > 1.0E-10) {
                double E = lplam * Math.cos(lpphi) / rh;
                out.x = rh * Math.sin(E);
                out.y = this.cphi1 - rh * Math.cos(E);
            } else {
                out.y = 0.0;
                out.x = 0.0;
            }
        } else {
            double E = Math.sin(lpphi);
            double c = Math.cos(lpphi);
            double rh = this.am1 + this.m1 - ProjectionMath.mlfn(lpphi, E, c, this.en);
            E = c * lplam / (rh * Math.sqrt(1.0 - this.es * E * E));
            out.x = rh * Math.sin(E);
            out.y = this.am1 - rh * Math.cos(E);
        }
        return out;
    }

    public ProjCoordinate projectInverse(double xyx, double xyy, ProjCoordinate out) {
        if (this.spherical) {
            out.y = this.cphi1 - xyy;
            double rh = ProjectionMath.distance(xyx, out.y);
            out.y = this.cphi1 + this.phi1 - rh;
            if (Math.abs(out.y) > 1.5707963267948966) {
                throw new ProjectionException("I");
            }
            out.x = Math.abs(Math.abs(out.y) - 1.5707963267948966) <= 1.0E-10 ? 0.0 : rh * Math.atan2(xyx, xyy) / Math.cos(out.y);
        } else {
            double d;
            out.y = this.am1 - xyy;
            double rh = ProjectionMath.distance(xyx, out.y);
            out.y = ProjectionMath.inv_mlfn(this.am1 + this.m1 - rh, this.es, this.en);
            double s = Math.abs(out.y);
            if (d < 1.5707963267948966) {
                s = Math.sin(out.y);
                out.x = rh * Math.atan2(xyx, xyy) * Math.sqrt(1.0 - this.es * s * s) / Math.cos(out.y);
            } else if (Math.abs(s - 1.5707963267948966) <= 1.0E-10) {
                out.x = 0.0;
            } else {
                throw new ProjectionException("I");
            }
        }
        return out;
    }

    public boolean isEqualArea() {
        return true;
    }

    public boolean hasInverse() {
        return true;
    }

    public void initialize() {
        super.initialize();
        this.phi1 = 1.5707963267948966;
        if (Math.abs(this.phi1) < 1.0E-10) {
            throw new ProjectionException("-23");
        }
        if (!this.spherical) {
            this.en = ProjectionMath.enfn(this.es);
            this.am1 = Math.sin(this.phi1);
            double c = Math.cos(this.phi1);
            this.m1 = ProjectionMath.mlfn(this.phi1, this.am1, c, this.en);
            this.am1 = c / (Math.sqrt(1.0 - this.es * this.am1 * this.am1) * this.am1);
        } else {
            this.cphi1 = Math.abs(this.phi1) + 1.0E-10 >= 1.5707963267948966 ? 0.0 : 1.0 / Math.tan(this.phi1);
        }
    }

    public String toString() {
        return "Bonne";
    }
}

