/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceController;
import org.teiid.adminapi.AdminComponentException;
import org.teiid.adminapi.AdminException;
import org.teiid.adminapi.VDB;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.client.util.ResultsFuture;
import org.teiid.core.BundleUtil;
import org.teiid.deployers.VDBRepository;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.service.SessionService;
import org.teiid.dqp.service.SessionServiceException;
import org.teiid.jboss.BaseOperationHandler;
import org.teiid.jboss.BufferManagerService;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.TeiidServiceNames;
import org.teiid.logging.LogManager;

abstract class TeiidOperationHandler
extends BaseOperationHandler<DQPCore> {
    protected TeiidOperationHandler(String operationName) {
        super(operationName);
    }

    protected TeiidOperationHandler(String operationName, boolean changesRuntime) {
        super(operationName, changesRuntime);
    }

    static VDBMetaData checkVDB(OperationContext context, String vdbName, String vdbVersion) throws OperationFailedException {
        ServiceController sc = context.getServiceRegistry(false).getRequiredService(TeiidServiceNames.VDB_REPO);
        VDBRepository repo = (VDBRepository)VDBRepository.class.cast(sc.getValue());
        VDBMetaData vdb = repo.getLiveVDB(vdbName, (Object)vdbVersion);
        if (vdb == null) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50102, new Object[]{vdb, vdbVersion}));
        }
        VDB.Status status = vdb.getStatus();
        if (status != VDB.Status.ACTIVE) {
            throw new OperationFailedException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50096, new Object[]{vdbName, vdbVersion}));
        }
        return vdb;
    }

    @Override
    protected DQPCore getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        ServiceController repo = context.getServiceRegistry(this.isChangesRuntimes()).getRequiredService(TeiidServiceNames.ENGINE);
        if (repo != null) {
            return (DQPCore)DQPCore.class.cast(repo.getValue());
        }
        return null;
    }

    protected BufferManagerService getBufferManager(OperationContext context) {
        ServiceController repo = context.getServiceRegistry(this.isChangesRuntimes()).getRequiredService(TeiidServiceNames.BUFFER_MGR);
        if (repo != null) {
            return (BufferManagerService)((Object)BufferManagerService.class.cast(repo.getService()));
        }
        return null;
    }

    protected VDBRepository getVDBrepository(OperationContext context) {
        ServiceController repo = context.getServiceRegistry(this.isChangesRuntimes()).getRequiredService(TeiidServiceNames.VDB_REPO);
        if (repo != null) {
            return (VDBRepository)VDBRepository.class.cast(repo.getValue());
        }
        return null;
    }

    protected int getSessionCount(OperationContext context) throws AdminException {
        try {
            return this.getSessionService(context).getActiveSessionsCount();
        }
        catch (SessionServiceException e) {
            throw new AdminComponentException((BundleUtil.Event)IntegrationPlugin.Event.TEIID50056, (Throwable)e);
        }
    }

    protected SessionService getSessionService(OperationContext context) {
        return (SessionService)context.getServiceRegistry(false).getService(TeiidServiceNames.SESSION).getValue();
    }

    public static ModelNode executeQuery(VDBMetaData vdb, DQPCore engine, String command, long timoutInMilli, final ModelNode resultsNode, final boolean timeAsString) throws OperationFailedException {
        String user = "CLI ADMIN";
        LogManager.logDetail((String)"org.teiid.RUNTIME", (Object)IntegrationPlugin.Util.getString("admin_executing", new Object[]{user, command}));
        try {
            ResultsFuture f = DQPCore.executeQuery((String)command, (VDBMetaData)vdb, (String)user, (String)"admin-console", (long)timoutInMilli, (DQPCore)engine, (DQPCore.ResultsListener)new DQPCore.ResultsListener(){

                public void onResults(List<String> columns, List<? extends List<?>> results) throws Exception {
                    TeiidOperationHandler.writeResults(resultsNode, columns, results, timeAsString);
                }
            });
            f.get();
        }
        catch (Throwable e) {
            throw new OperationFailedException(e);
        }
        return resultsNode;
    }

    private static void writeResults(ModelNode resultsNode, List<String> columns, List<? extends List<?>> results, boolean timeAsString) throws SQLException {
        for (List<?> row : results) {
            ModelNode rowNode = new ModelNode();
            for (int colNum = 0; colNum < columns.size(); ++colNum) {
                Object aValue = row.get(colNum);
                if (aValue == null) continue;
                if (aValue instanceof Integer) {
                    rowNode.get(columns.get(colNum)).set(((Integer)aValue).intValue());
                    continue;
                }
                if (aValue instanceof Long) {
                    rowNode.get(columns.get(colNum)).set(((Long)aValue).longValue());
                    continue;
                }
                if (aValue instanceof Double) {
                    rowNode.get(columns.get(colNum)).set(((Double)aValue).doubleValue());
                    continue;
                }
                if (aValue instanceof Boolean) {
                    rowNode.get(columns.get(colNum)).set(((Boolean)aValue).booleanValue());
                    continue;
                }
                if (aValue instanceof BigInteger) {
                    rowNode.get(columns.get(colNum)).set((BigInteger)aValue);
                    continue;
                }
                if (aValue instanceof BigDecimal) {
                    rowNode.get(columns.get(colNum)).set((BigDecimal)aValue);
                    continue;
                }
                if (aValue instanceof Timestamp && !timeAsString) {
                    rowNode.get(columns.get(colNum)).set(((Timestamp)aValue).getTime());
                    continue;
                }
                if (aValue instanceof Date && !timeAsString) {
                    rowNode.get(columns.get(colNum)).set(((Date)aValue).getTime());
                    continue;
                }
                if (aValue instanceof Time && !timeAsString) {
                    rowNode.get(columns.get(colNum)).set(((Time)aValue).getTime());
                    continue;
                }
                if (aValue instanceof String) {
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.STRING);
                    rowNode.get(columns.get(colNum)).set((String)aValue);
                    continue;
                }
                if (aValue instanceof Blob) {
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.OBJECT);
                    rowNode.get(columns.get(colNum)).set("blob");
                    continue;
                }
                if (aValue instanceof Clob) {
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.OBJECT);
                    rowNode.get(columns.get(colNum)).set("clob");
                    continue;
                }
                if (aValue instanceof SQLXML) {
                    SQLXML xml = (SQLXML)aValue;
                    rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.STRING);
                    rowNode.get(columns.get(colNum)).set(xml.getString());
                    continue;
                }
                rowNode.get(new String[]{columns.get(colNum), "type"}).set(ModelType.STRING);
                rowNode.get(columns.get(colNum)).set(aValue.toString());
            }
            resultsNode.add(rowNode);
        }
    }
}

