/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.ResolvePathHandler;
import org.jboss.dmr.ModelNode;
import org.teiid.jboss.IntegrationPlugin;

public abstract class BaseOperationHandler<T>
implements OperationStepHandler {
    private static final String DESCRIBE = ".describe";
    protected static final String MISSING = ".missing";
    protected static final String REPLY = ".reply";
    private String operationName;
    private boolean changesRuntime = false;

    protected BaseOperationHandler(String operationName) {
        this.operationName = operationName;
    }

    protected BaseOperationHandler(String operationName, boolean changesRuntime) {
        this.operationName = operationName;
        this.changesRuntime = changesRuntime;
    }

    public void register(ManagementResourceRegistration subsystem) {
        subsystem.registerOperationHandler(this.getOperationDefinition(), (OperationStepHandler)this);
    }

    public String name() {
        return this.operationName;
    }

    public boolean isChangesRuntimes() {
        return this.changesRuntime;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        if (context.isNormalServer()) {
            context.addStep(new OperationStepHandler(){

                public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                    ModelNode address = operation.require("address");
                    PathAddress pathAddress = PathAddress.pathAddress((ModelNode)address);
                    BaseOperationHandler.this.executeOperation(context, BaseOperationHandler.this.getService(context, pathAddress, operation), operation);
                    context.stepCompleted();
                }
            }, OperationContext.Stage.RUNTIME);
        }
        context.stepCompleted();
    }

    protected T getService(OperationContext context, PathAddress pathAddress, ModelNode operation) throws OperationFailedException {
        return null;
    }

    public OperationDefinition getOperationDefinition() {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder(this.operationName, (ResourceDescriptionResolver)new TeiidResourceDescriptionResolver(this.operationName));
        builder.setRuntimeOnly();
        this.describeParameters(builder);
        return builder.build();
    }

    protected abstract void executeOperation(OperationContext var1, T var2, ModelNode var3) throws OperationFailedException;

    protected void describeParameters(SimpleOperationDefinitionBuilder builder) {
    }

    static class TeiidResourceDescriptionResolver
    extends StandardResourceDescriptionResolver {
        private final String operationName;

        public ResourceBundle getResourceBundle(Locale locale) {
            if (locale == null) {
                locale = Locale.getDefault();
            }
            return IntegrationPlugin.getResourceBundle(locale);
        }

        public String getResourceAttributeDescription(String attributeName, Locale locale, ResourceBundle bundle) {
            return bundle.getString(attributeName);
        }

        public TeiidResourceDescriptionResolver(String operationName) {
            super("path", "org.teiid.jboss.i18n", ResolvePathHandler.class.getClassLoader(), false, false);
            this.operationName = operationName;
        }

        public String getOperationDescription(String operationName, Locale locale, ResourceBundle bundle) {
            if (this.operationName.equals(operationName)) {
                return bundle.getString(operationName + BaseOperationHandler.DESCRIBE);
            }
            return super.getOperationParameterDescription(operationName, operationName, locale, bundle);
        }

        public String getOperationParameterDescription(String operationName, String paramName, Locale locale, ResourceBundle bundle) {
            if (this.operationName.equals(operationName)) {
                return bundle.getString(this.operationName + "." + paramName + BaseOperationHandler.DESCRIBE);
            }
            return super.getOperationParameterDescription(operationName, paramName, locale, bundle);
        }

        public String getOperationReplyDescription(String operationName, Locale locale, ResourceBundle bundle) {
            if (this.operationName.equals(operationName)) {
                return bundle.getString(this.operationName + BaseOperationHandler.REPLY);
            }
            return super.getOperationReplyDescription(operationName, locale, bundle);
        }
    }
}

