/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jboss;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.HashMap;
import java.util.Map;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.vault.SecurityVaultException;
import org.jboss.security.vault.SecurityVaultUtil;
import org.picketbox.datasource.security.AbstractPasswordCredentialLoginModule;
import org.teiid.OAuthCredentialContext;
import org.teiid.core.BundleUtil;
import org.teiid.jboss.GSSUtil;
import org.teiid.jboss.IntegrationPlugin;
import org.teiid.jboss.SecurityActions;

public class PassthroughIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private static final String WRAP_GSS_CREDENTIAL = "wrapGSSCredential";
    private String userName;
    private char[] password;
    private Subject callerSubject;
    private boolean addPrincipal = true;
    private HashMap<String, Object> properties = new HashMap();
    private boolean wrapGssCredential;
    private Subject intermediateSubject;
    private GSSCredential storedCredential;

    public void initialize(Subject subject, CallbackHandler handler, Map<String, ?> sharedState, Map<String, ?> options) {
        super.initialize(subject, handler, sharedState, options);
        this.userName = (String)options.get("username");
        String pass = (String)options.get("password");
        if (pass != null) {
            if (SecurityVaultUtil.isVaultFormat((String)pass)) {
                try {
                    pass = SecurityVaultUtil.getValueAsString((String)pass);
                }
                catch (SecurityVaultException e) {
                    throw new RuntimeException(e);
                }
                this.password = pass.toCharArray();
            } else {
                this.password = pass.toCharArray();
            }
        }
        this.properties.putAll(options);
        this.wrapGssCredential = Boolean.parseBoolean((String)options.get(WRAP_GSS_CREDENTIAL));
        this.log.tracef("wrapGssCredential=%b", (Object)this.wrapGssCredential);
    }

    public boolean login() throws LoginException {
        String username = this.userName;
        try {
            Principal user = PassthroughIdentityLoginModule.getPrincipal();
            this.callerSubject = PassthroughIdentityLoginModule.getSubject();
            this.addPrincipal = false;
            if (user != null) {
                username = user.getName();
            }
        }
        catch (Throwable e) {
            throw new LoginException(e.getMessage());
        }
        this.userName = username;
        if (super.login()) {
            return true;
        }
        this.sharedState.put("javax.security.auth.login.name", username);
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        this.sharedState.put("javax.security.auth.login.name", this.userName);
        if (this.addPrincipal) {
            this.subject.getPrincipals().add(this.getIdentity());
            if (this.password != null) {
                PasswordCredential cred = new PasswordCredential(this.userName, this.password);
                SecurityActions.addCredentials(this.subject, cred);
            }
        }
        if (this.callerSubject != null) {
            GSSCredential rawCredential = this.getGssCredential(this.callerSubject);
            if (rawCredential != null) {
                this.log.trace((Object)"Kerberos passthough mechanism in works");
                this.storedCredential = this.wrapGssCredential ? PassthroughIdentityLoginModule.wrapCredential(rawCredential) : rawCredential;
                this.intermediateSubject = GSSUtil.createGssSubject(rawCredential, this.storedCredential);
                if (this.intermediateSubject == null) {
                    throw new LoginException(IntegrationPlugin.Util.gs((BundleUtil.Event)IntegrationPlugin.Event.TEIID50108, new Object[0]));
                }
                this.log.tracef("created a subject from deletegate credential", new Object[0]);
                PassthroughIdentityLoginModule.makeCopy(this.intermediateSubject, this.subject);
                this.log.tracef("Copied contents of temporary Subject to Subject from the LoginContext", new Object[0]);
                PassthroughIdentityLoginModule.addPrivateCredential(this.subject, this.storedCredential);
                this.log.trace((Object)"Also add the GSSCredential to the Subject");
            } else {
                PassthroughIdentityLoginModule.makeCopy(this.callerSubject, this.subject);
            }
        }
        PassthroughIdentityLoginModule.addPrivateCredential(this.subject, this.properties);
        this.log.trace((Object)"Adding module option properties as private credential");
        if (OAuthCredentialContext.getCredential() != null) {
            PassthroughIdentityLoginModule.addPrivateCredential(this.subject, OAuthCredentialContext.getCredential());
            this.log.trace((Object)"Adding OAuth credential as private credential");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (System.getSecurityManager() == null) {
            if (this.storedCredential != null) {
                PassthroughIdentityLoginModule.removePrivateCredential(this.subject, this.storedCredential);
                this.log.trace((Object)"Remove GSSCredential to the Subject");
            }
            PassthroughIdentityLoginModule.removePrivateCredential(this.subject, this.properties);
            this.clearSubjectContents(this.subject, this.intermediateSubject != null ? this.intermediateSubject : this.callerSubject);
            this.log.trace((Object)"Clear Subject contents");
            return true;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                if (PassthroughIdentityLoginModule.this.storedCredential != null) {
                    PassthroughIdentityLoginModule.removePrivateCredential(PassthroughIdentityLoginModule.this.subject, PassthroughIdentityLoginModule.this.storedCredential);
                    PassthroughIdentityLoginModule.this.log.trace((Object)"Remove GSSCredential to the Subject");
                }
                PassthroughIdentityLoginModule.removePrivateCredential(PassthroughIdentityLoginModule.this.subject, PassthroughIdentityLoginModule.this.properties);
                PassthroughIdentityLoginModule.this.clearSubjectContents(PassthroughIdentityLoginModule.this.subject, PassthroughIdentityLoginModule.this.intermediateSubject != null ? PassthroughIdentityLoginModule.this.intermediateSubject : PassthroughIdentityLoginModule.this.callerSubject);
                PassthroughIdentityLoginModule.this.log.trace((Object)"Clear Subject contents");
                return true;
            }
        });
    }

    private GSSCredential getGssCredential(Subject subject) {
        for (Object obj : subject.getPrivateCredentials()) {
            if (!(obj instanceof GSSCredential)) continue;
            return (GSSCredential)obj;
        }
        return null;
    }

    void clearSubjectContents(Subject toSubtract, Subject from) {
        from.getPrincipals().removeAll(toSubtract.getPrincipals());
        from.getPublicCredentials().removeAll(toSubtract.getPublicCredentials());
        from.getPrivateCredentials().removeAll(toSubtract.getPrivateCredentials());
    }

    protected Principal getIdentity() {
        SimplePrincipal principal = new SimplePrincipal(this.userName);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        return new Group[0];
    }

    static Principal getPrincipal() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getPrincipal();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Principal>(){

            @Override
            public Principal run() {
                return SecurityContextAssociation.getPrincipal();
            }
        });
    }

    static Subject getSubject() {
        if (System.getSecurityManager() == null) {
            return SecurityContextAssociation.getSubject();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Subject>(){

            @Override
            public Subject run() {
                return SecurityContextAssociation.getSubject();
            }
        });
    }

    static Object makeCopy(final Subject from, final Subject to) {
        if (System.getSecurityManager() == null) {
            PassthroughIdentityLoginModule.copy(from, to);
            return null;
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PassthroughIdentityLoginModule.copy(from, to);
                return null;
            }
        });
    }

    static void copy(Subject from, Subject to) {
        for (Principal p : from.getPrincipals()) {
            to.getPrincipals().add(p);
        }
        for (Object obj : from.getPrivateCredentials()) {
            to.getPrivateCredentials().add(obj);
        }
        for (Object obj : from.getPublicCredentials()) {
            to.getPublicCredentials().add(obj);
        }
    }

    static void addPrivateCredential(final Subject subject, final Object obj) {
        if (System.getSecurityManager() == null) {
            subject.getPrivateCredentials().add(obj);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    subject.getPrivateCredentials().add(obj);
                    return null;
                }
            });
        }
    }

    static void removePrivateCredential(final Subject subject, final Object obj) {
        if (System.getSecurityManager() == null) {
            subject.getPrivateCredentials().remove(obj);
        } else {
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    subject.getPrivateCredentials().remove(obj);
                    return null;
                }
            });
        }
    }

    private static GSSCredential wrapCredential(final GSSCredential credential) {
        return new GSSCredential(){

            @Override
            public int getUsage(Oid mech) throws GSSException {
                return credential.getUsage(mech);
            }

            @Override
            public int getUsage() throws GSSException {
                return credential.getUsage();
            }

            @Override
            public int getRemainingLifetime() throws GSSException {
                return credential.getRemainingLifetime();
            }

            @Override
            public int getRemainingInitLifetime(Oid mech) throws GSSException {
                return credential.getRemainingInitLifetime(mech);
            }

            @Override
            public int getRemainingAcceptLifetime(Oid mech) throws GSSException {
                return credential.getRemainingAcceptLifetime(mech);
            }

            @Override
            public GSSName getName(Oid mech) throws GSSException {
                return credential.getName(mech);
            }

            @Override
            public GSSName getName() throws GSSException {
                return credential.getName();
            }

            @Override
            public Oid[] getMechs() throws GSSException {
                return credential.getMechs();
            }

            @Override
            public void dispose() throws GSSException {
            }

            @Override
            public void add(GSSName name, int initLifetime, int acceptLifetime, Oid mech, int usage) throws GSSException {
                credential.add(name, initLifetime, acceptLifetime, mech, usage);
            }
        };
    }
}

