/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata;

import com.metamatrix.connector.metadata.PropertyFileObjectSource;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import junit.framework.TestCase;

public class TestPropertyFileObjectSource
extends TestCase {
    public TestPropertyFileObjectSource(String name) {
        super(name);
    }

    public void testNoneExistentFile() {
        PropertyFileObjectSource source = new PropertyFileObjectSource(null);
        String fileName = "fakeFiles/fake_does_not_exist.properties";
        try {
            source.getObjects(fileName, null);
            TestPropertyFileObjectSource.fail();
        }
        catch (MetaMatrixRuntimeException e) {
            TestPropertyFileObjectSource.assertEquals((String)(fileName + " file not found"), (String)e.getMessage());
        }
    }

    public void testNoProperties() {
        PropertyFileObjectSource source = new PropertyFileObjectSource(null);
        Iterator iterator = source.getObjects("fakeFiles/fake0.properties", null).iterator();
        TestPropertyFileObjectSource.assertFalse((boolean)iterator.hasNext());
    }

    public void testOneProperty() {
        PropertyFileObjectSource source = new PropertyFileObjectSource(null);
        Iterator iterator = source.getObjects("fakeFiles/fake1.properties", null).iterator();
        TestPropertyFileObjectSource.assertTrue((boolean)iterator.hasNext());
        Map.Entry next = (Map.Entry)iterator.next();
        TestPropertyFileObjectSource.assertEquals((Object)new Integer(1), next.getKey());
        TestPropertyFileObjectSource.assertEquals((String)"value1", (String)((String)next.getValue()));
        TestPropertyFileObjectSource.assertFalse((boolean)iterator.hasNext());
    }

    public void testTwoProperties() {
        PropertyFileObjectSource source = new PropertyFileObjectSource(null);
        Iterator iterator = source.getObjects("fakeFiles/fake2.properties", null).iterator();
        TestPropertyFileObjectSource.assertTrue((boolean)iterator.hasNext());
        Map.Entry next = (Map.Entry)iterator.next();
        Integer key1 = (Integer)next.getKey();
        if (key1.equals(new Integer(1))) {
            TestPropertyFileObjectSource.assertEquals((Object)new Integer(1), next.getKey());
            TestPropertyFileObjectSource.assertEquals((String)"value1", (String)((String)next.getValue()));
            TestPropertyFileObjectSource.assertTrue((boolean)iterator.hasNext());
            next = (Map.Entry)iterator.next();
            TestPropertyFileObjectSource.assertEquals((Object)new Integer(2), next.getKey());
            TestPropertyFileObjectSource.assertEquals((String)"value2", (String)((String)next.getValue()));
            TestPropertyFileObjectSource.assertFalse((boolean)iterator.hasNext());
        } else if (key1.equals(new Integer(2))) {
            TestPropertyFileObjectSource.assertEquals((Object)new Integer(2), next.getKey());
            TestPropertyFileObjectSource.assertEquals((String)"value2", (String)((String)next.getValue()));
            TestPropertyFileObjectSource.assertTrue((boolean)iterator.hasNext());
            next = (Map.Entry)iterator.next();
            TestPropertyFileObjectSource.assertEquals((Object)new Integer(1), next.getKey());
            TestPropertyFileObjectSource.assertEquals((String)"value1", (String)((String)next.getValue()));
            TestPropertyFileObjectSource.assertFalse((boolean)iterator.hasNext());
        } else {
            TestPropertyFileObjectSource.fail();
        }
    }

    public void testCriteria() {
        PropertyFileObjectSource source = new PropertyFileObjectSource(null);
        try {
            source.getObjects("fakeFiles/fake1.properties", this.helpGetCriteria());
            TestPropertyFileObjectSource.fail();
        }
        catch (UnsupportedOperationException e) {
            TestPropertyFileObjectSource.assertEquals((String)"Criteria is not supported", (String)e.getMessage());
        }
    }

    private Map helpGetCriteria() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("key", "key1");
        return result;
    }
}

