/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.ApplicationService;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.connector.metadata.IndexFile;
import com.metamatrix.connector.metadata.MultiObjectSource;
import com.metamatrix.connector.metadata.PropertyFileObjectSource;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.core.util.TempDirectoryMonitor;
import com.metamatrix.dqp.service.FakeVDBService;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.dqp.service.metadata.IndexSelectorSource;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.modeler.internal.core.index.CompositeIndexSelector;
import com.metamatrix.modeler.internal.core.index.RuntimeIndexSelector;
import com.metamatrix.modeler.transformation.metadata.ServerMetadataFactory;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;

public class FakeMetadataService
implements ApplicationService,
MetadataService,
IndexSelectorSource {
    private IndexSelector systemIndexSelector;
    private RuntimeIndexSelector runtimeIndexSelector;
    private boolean useOnlySystemVdb = false;

    public FakeMetadataService(String vdbFile) {
        this.runtimeIndexSelector = new RuntimeIndexSelector(vdbFile);
    }

    public FakeMetadataService(URL vdbFile) throws IOException {
        this.runtimeIndexSelector = new RuntimeIndexSelector(vdbFile);
    }

    public void setSystemIndexSelector(IndexSelector systemIndexSelector) {
        this.systemIndexSelector = systemIndexSelector;
    }

    public void useOnlySystemVdb() {
        this.useOnlySystemVdb = true;
    }

    private IndexSelector getIndexSelector(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        TempDirectoryMonitor.turnOn();
        RuntimeIndexSelector vdbSelector = this.runtimeIndexSelector;
        if (this.useOnlySystemVdb) {
            return this.systemIndexSelector;
        }
        if (this.systemIndexSelector == null) {
            return vdbSelector;
        }
        ArrayList<RuntimeIndexSelector> selectors = new ArrayList<RuntimeIndexSelector>();
        selectors.add(vdbSelector);
        CompositeIndexSelector result = new CompositeIndexSelector(selectors);
        return result;
    }

    public void clear() {
        if (this.runtimeIndexSelector != null) {
            this.runtimeIndexSelector.clearVDB();
            this.runtimeIndexSelector = null;
        }
        TempDirectoryMonitor.removeAll();
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
    }

    public void stop() throws ApplicationLifecycleException {
    }

    public QueryMetadataInterface lookupMetadata(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        return ServerMetadataFactory.getInstance().createCachingServerMetadata((IndexSelector)this.runtimeIndexSelector);
    }

    public IObjectSource getMetadataObjectSource(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        IndexSelector indexSelector = this.getIndexSelector(vdbName, vdbVersion);
        IndexFile indexFile = new IndexFile(indexSelector, vdbName, vdbVersion, (VDBService)new FakeVDBService());
        PropertyFileObjectSource propertyFileSource = new PropertyFileObjectSource();
        MultiObjectSource multiObjectSource = new MultiObjectSource((IObjectSource)indexFile, ".properties", (IObjectSource)propertyFileSource);
        return multiObjectSource;
    }
}

