/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata;

import com.metamatrix.connector.metadata.PropertyHolder;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.core.MetaMatrixRuntimeException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class PropertyFileObjectSource
implements IObjectSource {
    private String propertyFilePath;

    public PropertyFileObjectSource() {
        this("com/metamatrix/connector/metadata/enum/");
    }

    public PropertyFileObjectSource(String propertyFilePath) {
        this.propertyFilePath = propertyFilePath;
    }

    @Override
    public Collection getObjects(String propertyFileName, Map criteria) {
        if (criteria != null && criteria.size() > 0) {
            throw new UnsupportedOperationException("Criteria is not supported");
        }
        InputStream input = null;
        try {
            propertyFileName = this.expandPropertyFileName(propertyFileName);
            input = this.getClass().getClassLoader().getResourceAsStream(propertyFileName);
            if (input == null) {
                throw new MetaMatrixRuntimeException(propertyFileName + " file not found");
            }
            Properties properties = new Properties();
            properties.load(input);
            ArrayList<PropertyHolder> results = new ArrayList<PropertyHolder>();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                PropertyHolder holder = new PropertyHolder(new Integer((String)entry.getKey()));
                holder.setValue(entry.getValue());
                results.add(holder);
            }
            ArrayList<PropertyHolder> arrayList = results;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (IOException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private String expandPropertyFileName(String propertyFileName) {
        if (this.propertyFilePath == null) {
            return propertyFileName;
        }
        return this.propertyFilePath + propertyFileName;
    }
}

