/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.index;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.connector.metadata.index.IndexCriteriaBuilder;
import com.metamatrix.connector.metadata.index.MetadataInCriteria;
import com.metamatrix.connector.metadata.index.MetadataLiteralCriteria;
import com.metamatrix.connector.metadata.index.MetadataResultsPostProcessor;
import com.metamatrix.connector.metadata.index.VdbMetadataContext;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.index.IEntryResult;
import com.metamatrix.core.util.CharOperation;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.internal.core.index.Index;
import com.metamatrix.metadata.runtime.impl.FileRecordImpl;
import com.metamatrix.metadata.runtime.impl.RecordFactory;
import com.metamatrix.modeler.core.metadata.runtime.MetadataRecord;
import com.metamatrix.modeler.internal.core.index.SimpleIndexUtil;
import com.metamatrix.modeler.transformation.metadata.ServerRuntimeMetadata;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MetadataConnectorMetadata
extends ServerRuntimeMetadata {
    private final MetadataResultsPostProcessor processor;
    private boolean needSearchPostProcess = false;

    public MetadataConnectorMetadata(VdbMetadataContext context) {
        super(context);
        this.processor = new MetadataResultsPostProcessor(context);
    }

    public Collection getObjects(String tableName, Map criteria) {
        String indexFileName = tableName;
        int separatorLocation = tableName.indexOf(35);
        if (separatorLocation != -1) {
            indexFileName = tableName.substring(0, separatorLocation);
            char recordType = tableName.substring(separatorLocation + 1).charAt(0);
            MetadataLiteralCriteria recordTypeCriteria = new MetadataLiteralCriteria("Recordtype", new Character(recordType));
            criteria.put("Recordtype".toUpperCase(), recordTypeCriteria);
        }
        try {
            this.needSearchPostProcess = false;
            Collection results = this.findMetadataRecords(indexFileName, criteria, false);
            if (!results.isEmpty()) {
                return this.processor.processMetadataRecords(indexFileName, results, criteria, this.needSearchPostProcess);
            }
        }
        catch (MetaMatrixComponentException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection findMetadataRecords(String indexName, Map criteria, boolean returnFirstMatch) throws MetaMatrixComponentException {
        if (indexName.equalsIgnoreCase("FILES.INDEX")) {
            return this.getFileRecords(criteria, returnFirstMatch);
        }
        try {
            Index[] indexes = SimpleIndexUtil.getIndexes(indexName, super.getIndexSelector());
            if (indexes != null && indexes.length > 0) {
                Collection criteriaCollection = IndexCriteriaBuilder.getLiteralCriteria(criteria);
                ArrayList<String> prefixes = null;
                ArrayList<String> patterns = null;
                for (Map literalCriteria : criteriaCollection) {
                    if (this.hasFalseCriteria(criteria)) continue;
                    String prefixPattern = IndexCriteriaBuilder.getMatchPrefix(indexName, literalCriteria);
                    if (prefixPattern == null) {
                        if (patterns == null) {
                            patterns = new ArrayList<String>(criteriaCollection.size());
                        }
                        String matchPattern = IndexCriteriaBuilder.getMatchPattern(indexName, literalCriteria);
                        patterns.add(matchPattern);
                        continue;
                    }
                    if (prefixes == null) {
                        prefixes = new ArrayList<String>(criteriaCollection.size());
                    }
                    prefixes.add(prefixPattern);
                }
                IEntryResult[] results = null;
                boolean hasCaseFunctions = this.hasCaseFunctions(criteria);
                if (patterns != null) {
                    results = !hasCaseFunctions ? SimpleIndexUtil.queryIndex(null, indexes, patterns, false, true, returnFirstMatch) : SimpleIndexUtil.queryIndex(null, indexes, patterns, false, false, returnFirstMatch);
                } else if (prefixes != null) {
                    results = SimpleIndexUtil.queryIndex(null, indexes, prefixes, true, true, returnFirstMatch);
                    if (!hasCaseFunctions && !criteria.isEmpty()) {
                        this.needSearchPostProcess = criteria.size() != 1 || criteria.get("Recordtype".toUpperCase()) == null;
                    }
                }
                if (results != null && results.length > 0) {
                    return this.getMetadataRecords(results, criteria, hasCaseFunctions);
                }
            }
        }
        catch (MetaMatrixCoreException e) {
            throw new MetaMatrixComponentException((Throwable)e, e.getMessage());
        }
        return Collections.EMPTY_LIST;
    }

    protected Collection getMetadataRecords(IEntryResult[] results, Map criteria, boolean hasCaseFunctions) throws MetaMatrixComponentException {
        if (results != null && results.length > 0) {
            Collection records = RecordFactory.getMetadataRecord(results, null);
            Collection criteriaCollection = IndexCriteriaBuilder.getLiteralCriteria(criteria);
            for (Map literalCriteria : criteriaCollection) {
                HashMap updatedCriteria = new HashMap(literalCriteria.size());
                for (Map.Entry entry : criteria.entrySet()) {
                    String key = (String)entry.getKey();
                    updatedCriteria.put(key.toUpperCase(), entry.getValue());
                }
                String nameCriteria = IndexCriteriaBuilder.getValueInCriteria(updatedCriteria, "Name");
                if (StringUtil.isEmpty((String)nameCriteria)) continue;
                Iterator j = records.iterator();
                while (j.hasNext()) {
                    MetadataRecord record = (MetadataRecord)j.next();
                    if (StringUtil.isEmpty((String)record.getName())) continue;
                    String recordName = record.getName();
                    if (hasCaseFunctions) {
                        nameCriteria = nameCriteria.toUpperCase();
                        recordName = recordName.toUpperCase();
                    }
                    if (CharOperation.match(nameCriteria.toCharArray(), recordName.toCharArray(), true)) continue;
                    j.remove();
                }
            }
            return records;
        }
        return Collections.EMPTY_LIST;
    }

    private boolean hasFalseCriteria(Map criteria) {
        Object criteriaObj;
        boolean falseCriteria = false;
        Iterator iter = criteria.values().iterator();
        while (!(!iter.hasNext() || (criteriaObj = iter.next()) instanceof MetadataLiteralCriteria && (falseCriteria = ((MetadataLiteralCriteria)criteriaObj).isFalseCriteria()))) {
        }
        return falseCriteria;
    }

    private boolean hasCaseFunctions(Map criteria) {
        boolean caserFunctions = false;
        for (Object criteriaObj : criteria.values()) {
            if (criteriaObj instanceof MetadataLiteralCriteria ? (caserFunctions = ((MetadataLiteralCriteria)criteriaObj).hasFieldWithCaseFunctions()) : criteriaObj instanceof MetadataInCriteria && (caserFunctions = ((MetadataInCriteria)criteriaObj).hasFieldWithCaseFunctions())) break;
        }
        return caserFunctions;
    }

    protected Collection getFileRecords(Map criteria, boolean returnFirstMatch) {
        MetadataLiteralCriteria literalCriteria = (MetadataLiteralCriteria)criteria.get("getPathInVdb".toUpperCase());
        String pathInVDb = literalCriteria != null ? (String)literalCriteria.getEvaluatedValue() : null;
        ArrayList<FileRecordImpl> fileRecords = new ArrayList<FileRecordImpl>();
        String[] filePaths = super.getIndexSelector().getFilePaths();
        for (int i = 0; i < filePaths.length; ++i) {
            String filePath = filePaths[i];
            FileRecordImpl record = new FileRecordImpl();
            record.setIndexSelector(super.getIndexSelector());
            record.setPathInVdb(filePath);
            if (fileRecords.contains(record)) continue;
            if (pathInVDb != null) {
                if (!CharOperation.match(pathInVDb.toCharArray(), filePath.toCharArray(), false)) continue;
                fileRecords.add(record);
                if (!returnFirstMatch) continue;
                return fileRecords;
            }
            fileRecords.add(record);
        }
        return fileRecords;
    }
}

