/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.connector.metadata.internal;

import com.metamatrix.core.MetaMatrixRuntimeException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ReflectionWrapper {
    private final Object target;
    private final Class targetClass;

    public ReflectionWrapper(Object target) {
        this.target = target;
        this.targetClass = target.getClass();
    }

    public Object get(String propertyName) {
        Method method = null;
        try {
            method = this.targetClass.getMethod(propertyName, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            try {
                method = this.targetClass.getMethod("get" + propertyName, new Class[0]);
            }
            catch (NoSuchMethodException e1) {
                throw new MetaMatrixRuntimeException((Throwable)e1);
            }
        }
        try {
            return method.invoke(this.target, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }

    public Object set(String propertyName, Object[] propertyValues) {
        Method method = null;
        Class[] types = null;
        if (propertyValues != null) {
            types = new Class[propertyValues.length];
            for (int i = 0; i < propertyValues.length; ++i) {
                types[i] = propertyValues[i].getClass();
            }
        }
        try {
            method = this.targetClass.getMethod(propertyName, types);
        }
        catch (NoSuchMethodException e) {
            try {
                method = this.targetClass.getMethod("set" + propertyName, types);
            }
            catch (NoSuchMethodException e1) {
                throw new MetaMatrixRuntimeException((Throwable)e1);
            }
        }
        try {
            return method.invoke(this.target, propertyValues);
        }
        catch (IllegalAccessException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw new MetaMatrixRuntimeException((Throwable)e);
        }
    }
}

