/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.service.metadata;

import com.google.inject.Inject;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.application.ApplicationEnvironment;
import com.metamatrix.common.application.exception.ApplicationInitializationException;
import com.metamatrix.common.application.exception.ApplicationLifecycleException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.connector.metadata.IndexFile;
import com.metamatrix.connector.metadata.MultiObjectSource;
import com.metamatrix.connector.metadata.PropertyFileObjectSource;
import com.metamatrix.connector.metadata.internal.IObjectSource;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.service.MetadataService;
import com.metamatrix.dqp.service.VDBService;
import com.metamatrix.dqp.service.metadata.IndexSelectorSource;
import com.metamatrix.dqp.service.metadata.QueryMetadataCache;
import com.metamatrix.modeler.core.index.IndexSelector;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import java.util.Properties;

public class IndexMetadataService
implements MetadataService,
IndexSelectorSource {
    private VDBService vdbService;
    private boolean started = false;
    private QueryMetadataCache metadataCache;

    public IndexMetadataService() {
    }

    @Inject
    public IndexMetadataService(QueryMetadataCache metadataCache) {
        this.metadataCache = metadataCache;
    }

    public void initialize(Properties props) throws ApplicationInitializationException {
    }

    public void start(ApplicationEnvironment environment) throws ApplicationLifecycleException {
        if (!this.started) {
            this.vdbService = (VDBService)environment.findService("dqp.vdb");
            if (this.vdbService == null) {
                throw new ApplicationLifecycleException(DQPPlugin.Util.getString("IndexMetadataService.VDB_Service_is_not_available._1"));
            }
            this.started = true;
        }
    }

    public void stop() throws ApplicationLifecycleException {
        this.started = false;
        this.vdbService = null;
    }

    @Override
    public IObjectSource getMetadataObjectSource(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        IndexSelector indexSelector = this.metadataCache.getCompositeSelector(vdbName, vdbVersion);
        IndexFile indexFile = new IndexFile(indexSelector, vdbName, vdbVersion, this.vdbService);
        PropertyFileObjectSource propertyFileSource = new PropertyFileObjectSource();
        MultiObjectSource multiObjectSource = new MultiObjectSource(indexFile, ".properties", propertyFileSource);
        return multiObjectSource;
    }

    public QueryMetadataInterface lookupMetadata(String vdbName, String vdbVersion) throws MetaMatrixComponentException {
        LogManager.logTrace((String)"DQP", (Object[])new Object[]{"IndexMetadataService lookup VDB", vdbName, vdbVersion});
        QueryMetadataInterface qmi = this.metadataCache.lookupMetadata(vdbName, vdbVersion);
        if (qmi == null) {
            LogManager.logTrace((String)"DQP", (Object[])new Object[]{"IndexMetadataService cache miss for VDB", vdbName, vdbVersion});
            return this.metadataCache.lookupMetadata(vdbName, vdbVersion, this.vdbService.getVDBResource(vdbName, vdbVersion));
        }
        return qmi;
    }
}

