/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import com.metamatrix.core.index.IDocument;
import com.metamatrix.core.index.IQueryResult;

public class IndexedFile
implements IQueryResult,
Comparable<IndexedFile> {
    protected String path;
    protected int fileNumber;

    public IndexedFile(String path, int fileNum) {
        if (fileNum < 1) {
            throw new IllegalArgumentException();
        }
        this.fileNumber = fileNum;
        this.path = path;
    }

    public IndexedFile(IDocument document, int fileNum) {
        if (fileNum < 1) {
            throw new IllegalArgumentException();
        }
        this.path = document.getName();
        this.fileNumber = fileNum;
    }

    public int footprint() {
        return 16 + (32 + this.path.length() * 2);
    }

    public int getFileNumber() {
        return this.fileNumber;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setFileNumber(int fileNumber) {
        this.fileNumber = fileNumber;
    }

    public String toString() {
        return "IndexedFile(" + this.fileNumber + ": " + this.path + ")";
    }

    @Override
    public int compareTo(IndexedFile other) {
        return this.path.compareTo(other.path);
    }
}

