/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.internal.core.index;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Util {
    protected static ResourceBundle bundle;
    private static final String bundleName = "com.metamatrix.core.index.i18n";

    private Util() {
    }

    public static String bind(String id) {
        return Util.bind(id, null);
    }

    public static String bind(String id, String[] arguments) {
        if (id == null) {
            return "No message available";
        }
        String message = null;
        try {
            message = bundle.getString(id);
        }
        catch (MissingResourceException e) {
            return "Missing message: " + id + " in: " + bundleName;
        }
        return MessageFormat.format(message, arguments);
    }

    public static int compare(char[] str1, char[] str2) {
        int len1 = str1.length;
        int len2 = str2.length;
        int n = Math.min(len1, len2);
        int i = 0;
        while (n-- != 0) {
            char c2;
            char c1 = str1[i];
            if (c1 == (c2 = str2[i++])) continue;
            return c1 - c2;
        }
        return len1 - len2;
    }

    public static int prefixLength(char[] s1, char[] s2) {
        int len = 0;
        int max = Math.min(s1.length, s2.length);
        for (int i = 0; i < max && s1[i] == s2[i]; ++i) {
            ++len;
        }
        return len;
    }

    public static int prefixLength(String s1, String s2) {
        int len = 0;
        int max = Math.min(s1.length(), s2.length());
        for (int i = 0; i < max && s1.charAt(i) == s2.charAt(i); ++i) {
            ++len;
        }
        return len;
    }
}

