/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.impl;

import com.metamatrix.metadata.runtime.impl.AbstractMetadataRecord;
import com.metamatrix.metadata.runtime.impl.ListEntryRecordImpl;
import com.metamatrix.metadata.runtime.impl.MetadataRecordDelegate;
import com.metamatrix.modeler.core.metadata.runtime.ColumnSetRecord;
import com.metamatrix.modeler.core.metadata.runtime.ListEntryRecord;
import java.util.ArrayList;
import java.util.List;

public class ColumnSetRecordImpl
extends AbstractMetadataRecord
implements ColumnSetRecord {
    private List columnIDs;

    public ColumnSetRecordImpl() {
        this(new MetadataRecordDelegate());
    }

    protected ColumnSetRecordImpl(MetadataRecordDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public List getColumnIDs() {
        return this.columnIDs;
    }

    @Override
    public ListEntryRecord[] getColumnIdEntries() {
        ArrayList<ListEntryRecordImpl> entryRecords = new ArrayList<ListEntryRecordImpl>(this.columnIDs.size());
        int n = this.columnIDs.size();
        for (int i = 0; i < n; ++i) {
            String uuid = (String)this.columnIDs.get(i);
            int position = i + 1;
            entryRecords.add(new ListEntryRecordImpl(uuid, position));
        }
        return entryRecords.toArray(new ListEntryRecord[entryRecords.size()]);
    }

    @Override
    public boolean isAccessPattern() {
        return super.getRecordType() == 'H';
    }

    @Override
    public boolean isIndex() {
        return super.getRecordType() == 'L';
    }

    @Override
    public boolean isPrimaryKey() {
        return super.getRecordType() == 'K';
    }

    @Override
    public boolean isUniqueKey() {
        return super.getRecordType() == 'I';
    }

    @Override
    public boolean isResultSet() {
        return super.getRecordType() == 'C';
    }

    @Override
    public short getType() {
        return this.getKeyTypeForRecordType(this.getRecordType());
    }

    public void setColumnIDs(List list) {
        this.columnIDs = list;
    }

    protected short getKeyTypeForRecordType(char recordType) {
        switch (recordType) {
            case 'I': {
                return 2;
            }
            case 'L': {
                return 5;
            }
            case 'H': {
                return 4;
            }
            case 'K': {
                return 0;
            }
            case 'J': {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid record type, for key" + recordType);
    }
}

