/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.ElementID;
import com.metamatrix.metadata.runtime.api.GroupID;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.model.BasicGroupID;
import com.metamatrix.metadata.runtime.model.BasicMetadataID;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.util.RuntimeIDParser;

public class BasicElementID
extends BasicMetadataID
implements ElementID {
    private GroupID groupID = null;
    private ModelID modelID = null;

    public BasicElementID(String fullName, long internalUniqueID) {
        super(fullName, internalUniqueID);
        if (this.getNameComponents().size() < 3) {
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{"Invalid ElementID \"", fullName, "\". Number of name components must be > 2."});
            throw new MetaMatrixRuntimeException("ERR.008.005.0001", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0001"));
        }
    }

    public BasicElementID(String fullName) {
        super(fullName);
        if (this.getNameComponents().size() < 3) {
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{"Invalid ElementID \"", fullName, "\". Number of name components must be > 2."});
            throw new MetaMatrixRuntimeException("ERR.008.005.0001");
        }
    }

    public BasicElementID(String parentName, String name, long internalUniqueID) {
        super(parentName, name, internalUniqueID);
        if (this.getNameComponents().size() < 3) {
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{"Invalid ElementID \"", this.getFullName(), "\". Number of name components must be > 2."});
            throw new MetaMatrixRuntimeException("ERR.008.005.0001", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0001"));
        }
    }

    @Override
    public GroupID getGroupID() {
        if (this.groupID != null) {
            return this.groupID;
        }
        String groupName = RuntimeIDParser.getGroupFullName(this);
        this.groupID = new BasicGroupID(groupName);
        return this.groupID;
    }

    @Override
    public ModelID getModelID() {
        if (this.modelID != null) {
            return this.modelID;
        }
        this.modelID = new BasicModelID(this.getNameComponent(0));
        return this.modelID;
    }

    public String getModelName() {
        return this.getNameComponent(0);
    }

    public String getGroupName() {
        return RuntimeIDParser.getGroupName(this);
    }

    public void setGroupID(GroupID id) {
        this.groupID = id;
    }

    public void setModelID(ModelID id) {
        this.modelID = id;
    }
}

