/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.metadata.runtime.api.ElementID;
import com.metamatrix.metadata.runtime.api.Key;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.model.BasicKeyID;
import com.metamatrix.metadata.runtime.model.BasicMetadataObject;
import com.metamatrix.metadata.runtime.model.BasicVirtualDatabaseID;
import java.util.ArrayList;
import java.util.List;

public class BasicKey
extends BasicMetadataObject
implements Key {
    private String description;
    private boolean isPrimaryKey;
    private boolean isForeignKey;
    private boolean isAccessPattern;
    private boolean isIndexed;
    private short matchType = Short.MIN_VALUE;
    private boolean isUniqueKey;
    private short keyType;
    private MetadataID referencedKey;
    private transient List elements;
    private String alias;
    private long referencedKeyUid;
    private String path;

    public BasicKey(BasicKeyID keyID, BasicVirtualDatabaseID virtualDBID) {
        super(keyID, virtualDBID);
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getNameInSource() {
        String alias = this.getAlias();
        if (alias != null) {
            return alias;
        }
        return this.getName();
    }

    @Override
    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Override
    public List getElementIDs() {
        return this.elements;
    }

    @Override
    public MetadataID getReferencedKey() {
        return this.referencedKey;
    }

    @Override
    public boolean isPrimaryKey() {
        return this.isPrimaryKey;
    }

    @Override
    public boolean isForeignKey() {
        return this.isForeignKey;
    }

    @Override
    public boolean isUniqueKey() {
        return this.isUniqueKey;
    }

    @Override
    public boolean isIndexed() {
        return this.isIndexed;
    }

    @Override
    public boolean isAccessPattern() {
        return this.isAccessPattern;
    }

    @Override
    public short getKeyType() {
        return this.keyType;
    }

    @Override
    public short getMatchType() {
        return this.matchType;
    }

    public long getReferencedKeyUID() {
        return this.referencedKeyUid;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setIsIndexed(boolean isIndexed) {
        this.isIndexed = isIndexed;
    }

    public void setKeyType(short keyType) {
        this.keyType = keyType;
        if (keyType == 0) {
            this.isPrimaryKey = true;
        } else if (keyType == 1) {
            this.isForeignKey = true;
        } else if (keyType == 2) {
            this.isUniqueKey = true;
        } else if (keyType == 4) {
            this.isAccessPattern = true;
        }
    }

    public void setMatchType(short matchType) {
        this.matchType = matchType;
    }

    public void setReferencedKey(MetadataID referKey) {
        this.referencedKey = referKey;
    }

    public void setReferencedKeyUID(long uid) {
        this.referencedKeyUid = uid;
    }

    public void setElementIDs(List elements) {
        this.elements = elements;
    }

    public void clearElementIDs() {
        if (this.elements != null) {
            this.elements.clear();
        }
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void addElementID(ElementID elementID) {
        if (this.elements == null) {
            this.elements = new ArrayList();
        }
        this.elements.add(elementID);
    }
}

