/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.GroupID;
import com.metamatrix.metadata.runtime.api.KeyID;
import com.metamatrix.metadata.runtime.api.ModelID;
import com.metamatrix.metadata.runtime.model.BasicGroupID;
import com.metamatrix.metadata.runtime.model.BasicMetadataID;
import com.metamatrix.metadata.runtime.model.BasicModelID;
import com.metamatrix.metadata.runtime.util.RuntimeIDParser;

public class BasicKeyID
extends BasicMetadataID
implements KeyID {
    private GroupID groupID = null;
    private ModelID modelID = null;

    public BasicKeyID(String fullName, long internalUniqueID) {
        super(fullName, internalUniqueID);
        if (this.getNameComponents().size() < 3) {
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{"Invalid KeyID \"", fullName, "\". Number of name components must be > 2."});
            throw new MetaMatrixRuntimeException("ERR.008.005.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0003"));
        }
    }

    public BasicKeyID(String fullName) {
        super(fullName);
        if (this.getNameComponents().size() < 3) {
            LogManager.logDetail((String)"RUNTIME_METADATA", (Object[])new Object[]{"Invalid KeyID \"", fullName, "\". Number of name components must be > 2."});
            throw new MetaMatrixRuntimeException("ERR.008.005.0003", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0003"));
        }
    }

    @Override
    public GroupID getGroupID() {
        if (this.groupID != null) {
            return this.groupID;
        }
        String groupName = RuntimeIDParser.getGroupFullName(this);
        this.groupID = new BasicGroupID(groupName);
        return this.groupID;
    }

    @Override
    public ModelID getModelID() {
        if (this.modelID != null) {
            return this.modelID;
        }
        String modelName = this.getNameComponent(0);
        this.modelID = new BasicModelID(modelName);
        return this.modelID;
    }

    public String getModelName() {
        return this.getNameComponent(0);
    }

    public String getGroupName() {
        return RuntimeIDParser.getGroupName(this);
    }

    public void setGroupID(GroupID groupID) {
        this.groupID = groupID;
    }

    public void setModelID(ModelID modelID) {
        this.modelID = modelID;
    }
}

