/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metadata.runtime.model;

import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metadata.runtime.RuntimeMetadataPlugin;
import com.metamatrix.metadata.runtime.api.ElementID;
import com.metamatrix.metadata.runtime.api.KeyID;
import com.metamatrix.metadata.runtime.api.MetadataID;
import com.metamatrix.metadata.runtime.util.RuntimeIDParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BasicMetadataID
implements MetadataID {
    public static final long NOT_DEFINED = Long.MIN_VALUE;
    private long uid = Long.MIN_VALUE;
    public static String FAKE_NAME = "fName";
    public static final String DELIMITER = new String(new char[]{'.'});
    public static final String WILDCARD = "*";
    private String fullName;
    private String shortName;
    private int hashCode;
    private transient List atomicNames;
    private transient Object lock;

    public BasicMetadataID(String fullName) {
        this(fullName, Long.MIN_VALUE);
    }

    protected BasicMetadataID(String fullName, long internalUniqueID) {
        if (fullName == null) {
            throw new MetaMatrixRuntimeException("ERR.008.005.0004", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0004"));
        }
        if (fullName.trim().length() == 0) {
            throw new MetaMatrixRuntimeException("ERR.008.005.0005", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0005"));
        }
        this.fullName = fullName;
        this.uid = internalUniqueID;
        this.updateHashCode();
        this.lock = new Object();
    }

    protected BasicMetadataID(String parentName, String name, long internalUniqueID) {
        if (name == null) {
            throw new MetaMatrixRuntimeException("ERR.008.005.0004", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0004"));
        }
        if (name.trim().length() == 0) {
            throw new MetaMatrixRuntimeException("ERR.008.005.0005", RuntimeMetadataPlugin.Util.getString("ERR.008.005.0005"));
        }
        this.shortName = name;
        this.fullName = parentName == null ? name : parentName + DELIMITER + name;
        this.uid = internalUniqueID;
        this.updateHashCode();
        this.lock = new Object();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.lock = new Object();
    }

    public final String getFullName() {
        return this.fullName;
    }

    public final String getName() {
        if (this.shortName != null) {
            return this.shortName;
        }
        ArrayList nameComponents = new ArrayList(this.getNameComponents());
        int nameComponentCount = nameComponents.size();
        return (String)nameComponents.get(nameComponentCount - 1);
    }

    public final String getNameComponent(int index) {
        return (String)this.getNameComponents().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final List getNameComponents() {
        if (this.atomicNames == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.atomicNames != null) {
                    return this.atomicNames;
                }
                if (this.fullName.indexOf(46) != -1) {
                    this.atomicNames = StringUtil.split((String)this.fullName, (String)DELIMITER);
                } else {
                    this.atomicNames = new ArrayList(1);
                    this.atomicNames.add(this.fullName);
                }
                this.atomicNames = Collections.unmodifiableList(this.atomicNames);
            }
        }
        return this.atomicNames;
    }

    public final int size() {
        return this.getNameComponents().size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BasicMetadataID) {
            if (this.hashCode() != obj.hashCode()) {
                return false;
            }
            BasicMetadataID that = (BasicMetadataID)obj;
            if (this.getClass() != that.getClass()) {
                return false;
            }
            long thisUID = this.getUID();
            long thatUID = that.getUID();
            if (thisUID != Long.MIN_VALUE && thatUID != Long.MIN_VALUE) {
                return thisUID == thatUID;
            }
            return this.getFullName().equalsIgnoreCase(that.getFullName());
        }
        return false;
    }

    public int compareTo(Object obj) {
        BasicMetadataID that = (BasicMetadataID)obj;
        if (obj == null) {
            throw new MetaMatrixRuntimeException("ERR.008.000.0005", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0005"));
        }
        int diff = this.hashCode() - that.hashCode();
        if (diff != 0) {
            return diff;
        }
        if (this.getClass() != that.getClass()) {
            diff = this.getClass().hashCode() - that.getClass().hashCode();
            return diff;
        }
        return this.fullName.compareToIgnoreCase(that.fullName);
    }

    public int compareToByName(Object obj) {
        BasicMetadataID that = (BasicMetadataID)obj;
        if (obj == null) {
            throw new MetaMatrixRuntimeException("ERR.008.000.0005", RuntimeMetadataPlugin.Util.getString("ERR.008.000.0005"));
        }
        return this.fullName.compareToIgnoreCase(that.fullName);
    }

    public final int hashCode() {
        return this.hashCode;
    }

    public final String toString() {
        return this.fullName;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public final String getParentFullName() {
        int lastDelim = this.fullName.lastIndexOf(46);
        if (lastDelim == -1) {
            return null;
        }
        return this.fullName.substring(0, lastDelim);
    }

    public final boolean hasParent() {
        boolean result = false;
        if (this.atomicNames != null) {
            result = this.atomicNames.size() > 1;
        } else {
            int lastDelim = this.fullName.indexOf(46);
            if (lastDelim != -1) {
                result = true;
            }
        }
        return result;
    }

    protected final void updateHashCode() {
        this.hashCode = this.computeHashCode();
    }

    protected int computeHashCode() {
        return this.fullName.toLowerCase().hashCode();
    }

    public String getPath() {
        return RuntimeIDParser.getPath(this);
    }

    public long getUID() {
        return this.uid;
    }

    public void setUID(long uid) {
        this.uid = uid;
    }

    public void setName(String name, boolean isShortName) {
        if (this.getName().equals(FAKE_NAME)) {
            int lastComponentIndex = this.fullName.lastIndexOf(DELIMITER) + 1;
            this.fullName = lastComponentIndex == 0 ? name : this.fullName.substring(0, lastComponentIndex) + name;
            this.atomicNames = null;
            if (isShortName) {
                this.shortName = name;
            }
            this.updateHashCode();
        }
    }

    public void setFullName(String name) {
        this.fullName = name;
        this.atomicNames = null;
        this.updateHashCode();
    }

    public void setShortName(String name) {
        this.shortName = name;
    }

    public void setModelName(String modelName) {
        if (this.getNameComponents().size() > 1 && this.getNameComponent(0).equals(FAKE_NAME)) {
            int firstComponentIndex = this.fullName.indexOf(DELIMITER);
            this.fullName = modelName + this.fullName.substring(firstComponentIndex);
        }
        this.atomicNames = null;
        this.updateHashCode();
    }

    public void setGroupFullName(String newName) {
        if (this instanceof ElementID || this instanceof KeyID) {
            int index = this.fullName.lastIndexOf(".");
            this.fullName = newName + this.fullName.substring(index);
            this.atomicNames = null;
            this.updateHashCode();
        }
    }
}

